/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.ByteDecoder;
import com.mongodb.ByteEncoder;
import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBConnector;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.ObjectId;
import com.mongodb.util.JSON;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;

public class DBApiLayer
extends DB {
    static final boolean D = Boolean.getBoolean("DEBUG.DB");
    static final int NUM_CURSORS_BEFORE_KILL = 100;
    static final boolean SHOW = Boolean.getBoolean("DB.SHOW");
    final String _root;
    final String _rootPlusDot;
    final DBConnector _connector;
    final Map<String, MyCollection> _collections = Collections.synchronizedMap(new HashMap());
    final Map<String, DBApiLayer> _sisters = Collections.synchronizedMap(new HashMap());
    List<Long> _deadCursorIds = new Vector<Long>();
    static final List<DBObject> EMPTY = Collections.unmodifiableList(new LinkedList());

    protected DBApiLayer(String root, DBConnector connector) {
        super(root);
        this._root = root;
        this._rootPlusDot = this._root + ".";
        this._connector = connector;
    }

    protected void doInsert(ByteBuffer buf, DB.WriteConcern concern) throws MongoException {
        this._connector.say(this, 2002, buf, concern);
    }

    protected void doDelete(ByteBuffer buf, DB.WriteConcern concern) throws MongoException {
        this._connector.say(this, 2006, buf, concern);
    }

    protected void doUpdate(ByteBuffer buf, DB.WriteConcern concern) throws MongoException {
        this._connector.say(this, 2001, buf, concern);
    }

    protected void doKillCursors(ByteBuffer buf) throws MongoException {
        this._connector.say(this, 2007, buf, DB.WriteConcern.NORMAL);
    }

    protected int doQuery(ByteBuffer out, ByteBuffer in) throws MongoException {
        return this._connector.call(this, 2004, out, in);
    }

    protected int doGetMore(ByteBuffer out, ByteBuffer in) throws MongoException {
        return this._connector.call(this, 2005, out, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MyCollection doGetCollection(String name) {
        MyCollection c = this._collections.get(name);
        if (c != null) {
            return c;
        }
        Map<String, MyCollection> map = this._collections;
        synchronized (map) {
            c = this._collections.get(name);
            if (c != null) {
                return c;
            }
            c = new MyCollection(name);
            this._collections.put(name, c);
        }
        return c;
    }

    String _removeRoot(String ns) {
        if (!ns.startsWith(this._rootPlusDot)) {
            return ns;
        }
        return ns.substring(this._root.length() + 1);
    }

    public DBCollection getCollectionFromFull(String fullNameSpace) {
        if (fullNameSpace.indexOf(".") < 0) {
            return this.doGetCollection(fullNameSpace);
        }
        int idx = fullNameSpace.indexOf(".");
        String root = fullNameSpace.substring(0, idx);
        String table = fullNameSpace.substring(idx + 1);
        if (this._root.equals(root)) {
            return this.doGetCollection(table);
        }
        return this.getSisterDB(root).getCollection(table);
    }

    public DB getSisterDB(String dbName) {
        return new DBApiLayer(dbName, this._connector);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Result
    implements Iterator<DBObject> {
        SingleResult _curResult;
        Iterator<DBObject> _cur;
        final MyCollection _collection;
        final int _numToReturn;
        private long _totalBytes = 0L;
        private int _numGetMores = 0;
        private List<Integer> _sizes = new ArrayList<Integer>();

        Result(MyCollection coll, SingleResult res, int numToReturn) {
            this.init(res);
            this._collection = coll;
            this._numToReturn = numToReturn;
        }

        private void init(SingleResult res) {
            this._totalBytes += res._bytes;
            this._curResult = res;
            this._cur = res._lst.iterator();
            this._sizes.add(res._lst.size());
        }

        @Override
        public DBObject next() {
            if (this._cur.hasNext()) {
                return this._cur.next();
            }
            if (!this._curResult.hasGetMore()) {
                throw new RuntimeException("no more");
            }
            this._advance();
            return this.next();
        }

        @Override
        public boolean hasNext() {
            if (this._cur.hasNext()) {
                return true;
            }
            if (!this._curResult.hasGetMore()) {
                return false;
            }
            this._advance();
            return this.hasNext();
        }

        private void _advance() {
            if (this._curResult._cursor <= 0L) {
                throw new RuntimeException("can't advance a cursor <= 0");
            }
            ByteEncoder encoder = ByteEncoder.get();
            encoder._buf.putInt(0);
            encoder._put(this._curResult._fullNameSpace);
            encoder._buf.putInt(this._numToReturn);
            encoder._buf.putLong(this._curResult._cursor);
            encoder.flip();
            ByteDecoder decoder = ByteDecoder.get(DBApiLayer.this, this._collection);
            try {
                int len = DBApiLayer.this.doGetMore(encoder._buf, decoder._buf);
                decoder.doneReading(len);
                ++this._numGetMores;
                SingleResult res = new SingleResult(this._curResult._fullNameSpace, decoder);
                this.init(res);
            }
            catch (MongoException me) {
                throw new MongoInternalException("can't do getmore", me);
            }
            finally {
                decoder.done();
                encoder.done();
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("can't remove this way");
        }

        public String toString() {
            return "DBCursor";
        }

        protected void finalize() throws Throwable {
            if (this._curResult != null && this._curResult._cursor > 0L) {
                DBApiLayer.this._deadCursorIds.add(this._curResult._cursor);
            }
            super.finalize();
        }

        public long totalBytes() {
            return this._totalBytes;
        }

        int numGetMores() {
            return this._numGetMores;
        }

        List<Integer> getSizes() {
            return Collections.unmodifiableList(this._sizes);
        }
    }

    class SingleResult
    extends QueryHeader {
        final long _bytes;
        final String _fullNameSpace;
        final String _shortNameSpace;
        final List<DBObject> _lst;

        SingleResult(String fullNameSpace, ByteDecoder decoder) {
            super(decoder._buf);
            this._bytes = decoder.remaining();
            this._fullNameSpace = fullNameSpace;
            this._shortNameSpace = DBApiLayer.this._removeRoot(this._fullNameSpace);
            this.skipPastHeader(decoder._buf);
            this._lst = this._num == 0 ? EMPTY : (this._num < 3 ? new LinkedList<DBObject>() : new ArrayList<DBObject>(this._num));
            if (this._num > 0) {
                int num = 0;
                while (decoder.more() && num < this._num) {
                    DBObject o = decoder.readObject();
                    this._lst.add(o);
                    ++num;
                    if (!D) continue;
                    System.out.println("-- : " + o.keySet().size());
                    for (String s : o.keySet()) {
                        System.out.println("\t " + s + " : " + o.get(s));
                    }
                }
            }
        }

        boolean hasGetMore() {
            return this._num > 0 && this._cursor > 0L;
        }

        public String toString() {
            return "reserved:" + this._reserved + " _cursor:" + this._cursor + " _startingFrom:" + this._startingFrom + " _num:" + this._num;
        }
    }

    static class QueryHeader {
        final int _reserved;
        final long _cursor;
        final int _startingFrom;
        final int _num;

        QueryHeader(ByteBuffer buf) {
            this(buf, buf.position());
        }

        QueryHeader(ByteBuffer buf, int start) {
            this._reserved = buf.getInt(start);
            this._cursor = buf.getLong(start + 4);
            this._startingFrom = buf.getInt(start + 12);
            this._num = buf.getInt(16);
        }

        int headerSize() {
            return 20;
        }

        void skipPastHeader(ByteBuffer buf) {
            buf.position(buf.position() + this.headerSize());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyCollection
    extends DBCollection {
        final String _fullNameSpace;

        MyCollection(String name) {
            super(DBApiLayer.this, name);
            this._fullNameSpace = DBApiLayer.this._root + "." + name;
        }

        @Override
        public void doapply(DBObject o) {
        }

        @Override
        public void insert(DBObject o) throws MongoException {
            this.insert(new DBObject[]{o});
        }

        @Override
        public void insert(DBObject[] arr) throws MongoException {
            this.insert(arr, true);
        }

        @Override
        public void insert(List<DBObject> list) throws MongoException {
            this.insert(list.toArray(new DBObject[list.size()]), true);
        }

        protected void insert(DBObject obj, boolean shouldApply) throws MongoException {
            this.insert(new DBObject[]{obj}, shouldApply);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void insert(DBObject[] arr, boolean shouldApply) throws MongoException {
            if (SHOW) {
                for (DBObject o : arr) {
                    System.out.println("save:  " + this._fullNameSpace + " " + JSON.serialize(o));
                }
            }
            if (shouldApply) {
                for (DBObject o : arr) {
                    this.apply(o);
                    Object id = o.get("_id");
                    if (!(id instanceof ObjectId)) continue;
                    ((ObjectId)id)._new = false;
                }
            }
            int cur = 0;
            while (cur < arr.length) {
                ByteEncoder encoder = ByteEncoder.get();
                encoder._buf.putInt(0);
                encoder._put(this._fullNameSpace);
                int n = 0;
                while (cur < arr.length) {
                    DBObject o;
                    o = arr[cur];
                    int pos = encoder._buf.position();
                    try {
                        encoder.putObject(null, o);
                        ++n;
                    }
                    catch (BufferOverflowException e) {
                        if (n == 0) {
                            throw encoder.getTooLargeException();
                        }
                        encoder._buf.position(pos);
                        break;
                    }
                    ++cur;
                }
                encoder.flip();
                try {
                    DBApiLayer.this.doInsert(encoder._buf, this.getWriteConcern());
                }
                finally {
                    encoder.done();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(DBObject o) throws MongoException {
            if (SHOW) {
                System.out.println("remove: " + this._fullNameSpace + " " + JSON.serialize(o));
            }
            ByteEncoder encoder = ByteEncoder.get();
            encoder._buf.putInt(0);
            encoder._put(this._fullNameSpace);
            Set<String> keys = o.keySet();
            if (keys.size() == 1 && ((String)keys.iterator().next()).equals("_id") && o.get((String)keys.iterator().next()) instanceof ObjectId) {
                encoder._buf.putInt(1);
            } else {
                encoder._buf.putInt(0);
            }
            encoder.putObject(o);
            encoder.flip();
            try {
                DBApiLayer.this.doDelete(encoder._buf, this.getWriteConcern());
            }
            finally {
                encoder.done();
            }
        }

        void _cleanCursors() throws MongoException {
            if (DBApiLayer.this._deadCursorIds.size() == 0) {
                return;
            }
            if (DBApiLayer.this._deadCursorIds.size() % 20 != 0 && DBApiLayer.this._deadCursorIds.size() < 100) {
                return;
            }
            List<Long> l = DBApiLayer.this._deadCursorIds;
            DBApiLayer.this._deadCursorIds = new Vector<Long>();
            Bytes.LOGGER.info("trying to kill cursors : " + l.size());
            try {
                this.killCursors(l);
            }
            catch (Throwable t) {
                Bytes.LOGGER.log(Level.WARNING, "can't clean cursors", t);
                DBApiLayer.this._deadCursorIds.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void killCursors(List<Long> all) throws MongoException {
            if (all == null || all.size() == 0) {
                return;
            }
            ByteEncoder encoder = ByteEncoder.get();
            encoder._buf.putInt(0);
            encoder._buf.putInt(all.size());
            for (Long l : all) {
                encoder._buf.putLong(l);
            }
            try {
                DBApiLayer.this.doKillCursors(encoder._buf);
            }
            finally {
                encoder.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<DBObject> find(DBObject ref, DBObject fields, int numToSkip, int batchSize, int options) throws MongoException {
            if (ref == null) {
                ref = new BasicDBObject();
            }
            if (SHOW) {
                System.out.println("find: " + this._fullNameSpace + " " + JSON.serialize(ref));
            }
            this._cleanCursors();
            ByteEncoder encoder = ByteEncoder.get();
            encoder._buf.putInt(options);
            encoder._put(this._fullNameSpace);
            encoder._buf.putInt(numToSkip);
            encoder._buf.putInt(batchSize);
            encoder.putObject(ref);
            if (fields != null) {
                encoder.putObject(fields);
            }
            encoder.flip();
            ByteDecoder decoder = ByteDecoder.get(DBApiLayer.this, this);
            try {
                Object err;
                int len = DBApiLayer.this.doQuery(encoder._buf, decoder._buf);
                decoder.doneReading(len);
                SingleResult res = new SingleResult(this._fullNameSpace, decoder);
                if (res._lst.size() == 0) {
                    Iterator<DBObject> iterator = null;
                    return iterator;
                }
                if (res._lst.size() == 1 && (err = res._lst.get(0).get("$err")) != null) {
                    throw new RuntimeException("db error [" + err + "]");
                }
                Result result = new Result(this, res, batchSize);
                return result;
            }
            finally {
                decoder.done();
                encoder.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(DBObject query, DBObject o, boolean upsert, boolean multi) throws MongoException {
            if (SHOW) {
                System.out.println("update: " + this._fullNameSpace + " " + JSON.serialize(query));
            }
            ByteEncoder encoder = ByteEncoder.get();
            encoder._buf.putInt(0);
            encoder._put(this._fullNameSpace);
            int flags = 0;
            if (upsert) {
                flags |= 1;
            }
            if (multi) {
                flags |= 2;
            }
            encoder._buf.putInt(flags);
            encoder.putObject(query);
            encoder.putObject(o);
            encoder.flip();
            try {
                DBApiLayer.this.doUpdate(encoder._buf, this.getWriteConcern());
            }
            finally {
                encoder.done();
            }
        }

        @Override
        protected void createIndex(DBObject keys, DBObject options) throws MongoException {
            BasicDBObject full = new BasicDBObject();
            for (String k : options.keySet()) {
                full.put(k, options.get(k));
            }
            full.put("key", (Object)keys);
            DBApiLayer.this.doGetCollection("system.indexes").insert(full, false);
        }
    }
}

