/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DBCallbackFactory;
import com.mongodb.DefaultDBCallback;
import com.mongodb.WriteConcern;

public class MongoOptions {
    public String description;
    public int connectionsPerHost;
    public int threadsAllowedToBlockForConnectionMultiplier;
    public int maxWaitTime;
    public int connectTimeout;
    public int socketTimeout;
    public boolean socketKeepAlive;
    public boolean autoConnectRetry;
    public boolean slaveOk;
    public DBCallbackFactory dbCallbackFactory;
    public boolean safe;
    public int w;
    public int wtimeout;
    public boolean fsync;

    public MongoOptions() {
        this.reset();
    }

    public void reset() {
        this.connectionsPerHost = Bytes.CONNECTIONS_PER_HOST;
        this.threadsAllowedToBlockForConnectionMultiplier = 5;
        this.maxWaitTime = 120000;
        this.connectTimeout = 0;
        this.socketTimeout = 0;
        this.socketKeepAlive = false;
        this.autoConnectRetry = false;
        this.slaveOk = false;
        this.safe = false;
        this.w = 0;
        this.wtimeout = 0;
        this.fsync = false;
        this.dbCallbackFactory = DefaultDBCallback.FACTORY;
    }

    public WriteConcern getWriteConcern() {
        if (this.w != 0 || this.wtimeout != 0 || this.fsync) {
            return new WriteConcern(this.w, this.wtimeout, this.fsync);
        }
        if (this.safe) {
            return WriteConcern.SAFE;
        }
        return WriteConcern.NORMAL;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("description=").append(this.description).append(", ");
        buf.append("connectionsPerHost=").append(this.connectionsPerHost).append(", ");
        buf.append("threadsAllowedToBlockForConnectionMultiplier=").append(this.threadsAllowedToBlockForConnectionMultiplier).append(", ");
        buf.append("maxWaitTime=").append(this.maxWaitTime).append(", ");
        buf.append("connectTimeout=").append(this.connectTimeout).append(", ");
        buf.append("socketTimeout=").append(this.socketTimeout).append(", ");
        buf.append("socketKeepAlive=").append(this.socketKeepAlive).append(", ");
        buf.append("autoConnectRetry=").append(this.autoConnectRetry).append(", ");
        buf.append("slaveOk=").append(this.slaveOk).append(", ");
        buf.append("safe=").append(this.safe).append(", ");
        buf.append("w=").append(this.w).append(", ");
        buf.append("wtimeout=").append(this.wtimeout).append(", ");
        buf.append("fsync=").append(this.fsync);
        return buf.toString();
    }
}

