/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.pojo.FieldAccessor;
import org.bson.codecs.pojo.FieldModel;
import org.bson.codecs.pojo.FieldSerialization;
import org.bson.codecs.pojo.PojoBuilderHelper;
import org.bson.codecs.pojo.TypeData;

public final class FieldModelBuilder<T> {
    private String fieldName;
    private String documentFieldName;
    private TypeData<T> typeData;
    private FieldSerialization<T> fieldSerialization;
    private Codec<T> codec;
    private FieldAccessor<T> fieldAccessor;
    private List<Annotation> annotations = Collections.emptyList();
    private Boolean discriminatorEnabled;

    FieldModelBuilder(Field field) {
        PojoBuilderHelper.configureFieldModelBuilder(this, field);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDocumentFieldName() {
        return this.documentFieldName;
    }

    public FieldModelBuilder<T> documentFieldName(String documentFieldName) {
        this.documentFieldName = Assertions.notNull("documentFieldName", documentFieldName);
        return this;
    }

    public FieldModelBuilder<T> codec(Codec<T> codec) {
        this.codec = codec;
        return this;
    }

    Codec<T> getCodec() {
        return this.codec;
    }

    public FieldModelBuilder<T> fieldSerialization(FieldSerialization<T> fieldSerialization) {
        this.fieldSerialization = Assertions.notNull("fieldSerialization", fieldSerialization);
        return this;
    }

    public FieldSerialization<T> getFieldSerialization() {
        return this.fieldSerialization;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public FieldModelBuilder<T> annotations(List<Annotation> annotations) {
        this.annotations = Collections.unmodifiableList(Assertions.notNull("annotations", annotations));
        return this;
    }

    public Boolean isDiscriminatorEnabled() {
        return this.discriminatorEnabled;
    }

    public FieldModelBuilder<T> discriminatorEnabled(boolean discriminatorEnabled) {
        this.discriminatorEnabled = discriminatorEnabled;
        return this;
    }

    public FieldAccessor<T> getFieldAccessor() {
        return this.fieldAccessor;
    }

    public FieldModelBuilder<T> fieldAccessor(FieldAccessor<T> fieldAccessor) {
        this.fieldAccessor = fieldAccessor;
        return this;
    }

    public FieldModel<T> build() {
        return new FieldModel<T>(PojoBuilderHelper.stateNotNull("fieldName", this.fieldName), PojoBuilderHelper.stateNotNull("documentFieldName", this.documentFieldName), PojoBuilderHelper.stateNotNull("typeData", this.typeData), this.codec, PojoBuilderHelper.stateNotNull("fieldModelSerialization", this.fieldSerialization), this.discriminatorEnabled, PojoBuilderHelper.stateNotNull("fieldAccessor", this.fieldAccessor));
    }

    public String toString() {
        return String.format("FieldModelBuilder{fieldName=%s, typeData=%s}", this.fieldName, this.typeData);
    }

    FieldModelBuilder<T> fieldName(String fieldName) {
        this.fieldName = Assertions.notNull("fieldName", fieldName);
        return this;
    }

    TypeData<T> getTypeData() {
        return this.typeData;
    }

    FieldModelBuilder<T> typeData(TypeData<T> typeData) {
        this.typeData = Assertions.notNull("typeData", typeData);
        return this;
    }
}

