/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.concurrent.ConcurrentMap;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.ClassModel;
import org.bson.codecs.pojo.DiscriminatorLookup;
import org.bson.codecs.pojo.PojoCodec;
import org.bson.codecs.pojo.PojoCodecProvider;

class LazyPojoCodec<T>
implements Codec<T> {
    private final ClassModel<T> classModel;
    private final PojoCodecProvider codecProvider;
    private final CodecRegistry registry;
    private final DiscriminatorLookup discriminatorLookup;
    private final ConcurrentMap<ClassModel<?>, Codec<?>> codecCache;
    private volatile PojoCodec<T> pojoCodec;

    LazyPojoCodec(ClassModel<T> classModel, PojoCodecProvider codecProvider, CodecRegistry registry, DiscriminatorLookup discriminatorLookup, ConcurrentMap<ClassModel<?>, Codec<?>> codecCache) {
        this.classModel = classModel;
        this.codecProvider = codecProvider;
        this.registry = registry;
        this.discriminatorLookup = discriminatorLookup;
        this.codecCache = codecCache;
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        this.getPojoCodec().encode(writer, value, encoderContext);
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.classModel.getType();
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return this.getPojoCodec().decode(reader, decoderContext);
    }

    private Codec<T> getPojoCodec() {
        if (this.pojoCodec == null) {
            this.pojoCodec = new PojoCodec<T>(this.classModel, this.codecProvider, this.registry, this.discriminatorLookup, this.codecCache, true);
        }
        return this.pojoCodec;
    }
}

