/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonReaderMark;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.ClassModel;
import org.bson.codecs.pojo.CollectionCodec;
import org.bson.codecs.pojo.DiscriminatorLookup;
import org.bson.codecs.pojo.EnumCodec;
import org.bson.codecs.pojo.FieldModel;
import org.bson.codecs.pojo.InstanceCreator;
import org.bson.codecs.pojo.LazyPojoCodec;
import org.bson.codecs.pojo.MapCodec;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.codecs.pojo.TypeData;
import org.bson.codecs.pojo.TypeParameterMap;
import org.bson.diagnostics.Logger;
import org.bson.diagnostics.Loggers;

final class PojoCodec<T>
implements Codec<T> {
    private static final Logger LOGGER = Loggers.getLogger("PojoCodec");
    private final ClassModel<T> classModel;
    private final PojoCodecProvider codecProvider;
    private final CodecRegistry registry;
    private final DiscriminatorLookup discriminatorLookup;
    private final ConcurrentMap<ClassModel<?>, Codec<?>> codecCache;
    private final boolean specialized;

    PojoCodec(ClassModel<T> classModel, PojoCodecProvider codecProvider, CodecRegistry registry, DiscriminatorLookup discriminatorLookup) {
        this(classModel, codecProvider, registry, discriminatorLookup, new ConcurrentHashMap(), !classModel.hasTypeParameters());
    }

    PojoCodec(ClassModel<T> classModel, PojoCodecProvider codecProvider, CodecRegistry registry, DiscriminatorLookup discriminatorLookup, ConcurrentMap<ClassModel<?>, Codec<?>> codecCache, boolean specialized) {
        this.classModel = classModel;
        this.codecProvider = codecProvider;
        this.registry = CodecRegistries.fromRegistries(CodecRegistries.fromCodecs(this), registry);
        this.discriminatorLookup = discriminatorLookup;
        this.codecCache = codecCache;
        this.specialized = specialized;
        if (specialized) {
            codecCache.put(classModel, this);
            for (FieldModel<?> fieldModel : classModel.getFieldModels()) {
                this.addToCache(fieldModel);
            }
        }
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        if (!this.specialized) {
            throw new CodecConfigurationException("Cannot encode an unspecialized generic ClassModel");
        }
        writer.writeStartDocument();
        FieldModel<?> idFieldModel = this.classModel.getIdFieldModel();
        if (idFieldModel != null) {
            this.encodeField(writer, value, encoderContext, idFieldModel);
        }
        if (this.classModel.useDiscriminator()) {
            writer.writeString(this.classModel.getDiscriminatorKey(), this.classModel.getDiscriminator());
        }
        for (FieldModel<?> fieldModel : this.classModel.getFieldModels()) {
            if (fieldModel.equals(this.classModel.getIdFieldModel())) continue;
            this.encodeField(writer, value, encoderContext, fieldModel);
        }
        writer.writeEndDocument();
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        if (decoderContext.hasCheckedDiscriminator()) {
            if (!this.specialized) {
                throw new CodecConfigurationException("Cannot decode using an unspecialized generic ClassModel");
            }
            InstanceCreator<T> instanceCreator = this.classModel.getInstanceCreator();
            this.decodeFields(reader, decoderContext, instanceCreator);
            return instanceCreator.getInstance();
        }
        return this.getCodecFromDocument(reader, this.classModel.useDiscriminator(), this.classModel.getDiscriminatorKey(), this.registry, this.discriminatorLookup, this).decode(reader, DecoderContext.builder().checkedDiscriminator(true).build());
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.classModel.getType();
    }

    public String toString() {
        return String.format("PojoCodec<%s>", this.classModel);
    }

    ClassModel<T> getClassModel() {
        return this.classModel;
    }

    private <S> void encodeField(BsonWriter writer, T instance, EncoderContext encoderContext, FieldModel<S> fieldModel) {
        S fieldValue = fieldModel.getFieldAccessor().get(instance);
        if (fieldModel.shouldSerialize(fieldValue)) {
            writer.writeName(fieldModel.getDocumentFieldName());
            if (fieldValue == null) {
                writer.writeNull();
            } else {
                this.getInstanceCodec(fieldModel, fieldValue.getClass()).encode(writer, fieldValue, encoderContext);
            }
        }
    }

    private void decodeFields(BsonReader reader, DecoderContext decoderContext, InstanceCreator<T> instanceCreator) {
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String name = reader.readName();
            if (this.classModel.useDiscriminator() && this.classModel.getDiscriminatorKey().equals(name)) {
                reader.readString();
                continue;
            }
            this.decodeFieldModel(reader, decoderContext, instanceCreator, name, this.classModel.getFieldModel(name));
        }
        reader.readEndDocument();
    }

    private <S> void decodeFieldModel(BsonReader reader, DecoderContext decoderContext, InstanceCreator<T> instanceCreator, String name, FieldModel<S> fieldModel) {
        if (fieldModel != null) {
            try {
                Object value = null;
                if (reader.getCurrentBsonType() == BsonType.NULL) {
                    reader.readNull();
                } else {
                    value = decoderContext.decodeWithChildContext(fieldModel.getCachedCodec(), reader);
                }
                instanceCreator.set(value, fieldModel);
            }
            catch (BsonInvalidOperationException e) {
                throw new CodecConfigurationException(String.format("Failed to decode '%s'. %s", name, e.getMessage()), e);
            }
            catch (CodecConfigurationException e) {
                throw new CodecConfigurationException(String.format("Failed to decode '%s'. %s", name, e.getMessage()), e);
            }
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Found field not present in the ClassModel: %s", name));
            }
            reader.skipValue();
        }
    }

    private <S> void addToCache(FieldModel<S> fieldModel) {
        Codec<S> codec = fieldModel.getCodec() != null ? fieldModel.getCodec() : this.specializePojoCodec(fieldModel, this.getCodecFromTypeData(fieldModel.getTypeData()));
        fieldModel.cachedCodec(codec);
    }

    private <S> Codec<S> getCodecFromTypeData(TypeData<S> typeData) {
        Codec<Collection<Object>> codec = null;
        Class head = typeData.getType();
        if (Collection.class.isAssignableFrom(head)) {
            codec = new CollectionCodec(head, this.getCodecFromTypeData(typeData.getTypeParameters().get(0)));
        } else if (Map.class.isAssignableFrom(head)) {
            codec = new MapCodec(head, this.getCodecFromTypeData(typeData.getTypeParameters().get(1)));
        } else if (Enum.class.isAssignableFrom(head)) {
            try {
                codec = this.registry.get(head);
            }
            catch (CodecConfigurationException e) {
                codec = new EnumCodec(head);
            }
        } else {
            codec = this.getCodecFromClass(head);
        }
        return codec;
    }

    private <S, V> Codec<S> getInstanceCodec(FieldModel<S> fieldModel, Class<V> instanceType) {
        Codec<Object> codec = fieldModel.getCachedCodec();
        if (!this.areEquivalentTypes(codec.getEncoderClass(), instanceType)) {
            codec = this.registry.get(instanceType);
        }
        return codec;
    }

    private <S, V> boolean areEquivalentTypes(Class<S> t1, Class<V> t2) {
        if (t1.equals(t2)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(t1) && Collection.class.isAssignableFrom(t2)) {
            return true;
        }
        return Map.class.isAssignableFrom(t1) && Map.class.isAssignableFrom(t2);
    }

    private <S> Codec<S> getCodecFromClass(Class<S> clazz) {
        Codec<S> codec = null;
        codec = this.classModel.getType().equals(clazz) ? this : this.codecProvider.getPojoCodec(clazz, this.registry);
        if (codec == null) {
            codec = this.registry.get(clazz);
        }
        return codec;
    }

    private <S> Codec<S> specializePojoCodec(FieldModel<S> fieldModel, Codec<S> defaultCodec) {
        LazyPojoCodec<T> codec = defaultCodec;
        if (codec != null && codec instanceof PojoCodec) {
            PojoCodec pojoCodec = (PojoCodec)((Object)codec);
            ClassModel<T> specialized = this.getSpecializedClassModel(pojoCodec.getClassModel(), fieldModel);
            codec = this.codecCache.containsKey(specialized) ? (LazyPojoCodec<T>)this.codecCache.get(specialized) : new LazyPojoCodec<T>(specialized, this.codecProvider, this.registry, this.discriminatorLookup, this.codecCache);
        }
        return codec;
    }

    private <S, V> ClassModel<S> getSpecializedClassModel(ClassModel<S> clazzModel, FieldModel<V> fieldModel) {
        boolean changeTheDiscriminator;
        boolean useDiscriminator = fieldModel.useDiscriminator() == null ? clazzModel.useDiscriminator() : fieldModel.useDiscriminator().booleanValue();
        boolean validDiscriminator = clazzModel.getDiscriminatorKey() != null && clazzModel.getDiscriminator() != null;
        boolean bl = changeTheDiscriminator = useDiscriminator != clazzModel.useDiscriminator() && validDiscriminator;
        if (fieldModel.getTypeData().getTypeParameters().isEmpty() && !changeTheDiscriminator) {
            return clazzModel;
        }
        ArrayList concreteFieldModels = new ArrayList(clazzModel.getFieldModels());
        FieldModel<?> concreteIdField = clazzModel.getIdFieldModel();
        List<TypeData<?>> fieldTypeParameters = fieldModel.getTypeData().getTypeParameters();
        for (int i = 0; i < concreteFieldModels.size(); ++i) {
            FieldModel<?> model = concreteFieldModels.get(i);
            String fieldName = model.getFieldName();
            TypeParameterMap typeParameterMap = clazzModel.getFieldNameToTypeParameterMap().get(fieldName);
            if (!typeParameterMap.hasTypeParameters()) continue;
            FieldModel<?> concreteFieldModel = this.getSpecializedFieldModel(model, typeParameterMap, fieldTypeParameters);
            concreteFieldModels.set(i, concreteFieldModel);
            if (concreteIdField == null || !concreteIdField.getFieldName().equals(fieldName)) continue;
            concreteIdField = concreteFieldModel;
        }
        boolean discriminatorEnabled = changeTheDiscriminator ? fieldModel.useDiscriminator().booleanValue() : clazzModel.useDiscriminator();
        return new ClassModel<S>(clazzModel.getType(), clazzModel.getFieldNameToTypeParameterMap(), clazzModel.getInstanceCreatorFactory(), discriminatorEnabled, clazzModel.getDiscriminatorKey(), clazzModel.getDiscriminator(), concreteIdField, concreteFieldModels);
    }

    private <V> FieldModel<V> getSpecializedFieldModel(FieldModel<V> fieldModel, TypeParameterMap typeParameterMap, List<TypeData<?>> fieldTypeParameters) {
        TypeData<Object> specializedFieldType = fieldModel.getTypeData();
        Map<Integer, Integer> fieldToClassParamIndexMap = typeParameterMap.getFieldToClassParamIndexMap();
        Integer classTypeParamRepresentsWholeField = fieldToClassParamIndexMap.get(-1);
        if (classTypeParamRepresentsWholeField != null) {
            specializedFieldType = fieldTypeParameters.get(classTypeParamRepresentsWholeField);
        } else {
            TypeData.Builder<V> builder = TypeData.builder(fieldModel.getTypeData().getType());
            ArrayList typeParameters = new ArrayList(fieldModel.getTypeData().getTypeParameters());
            for (int i = 0; i < typeParameters.size(); ++i) {
                for (Map.Entry<Integer, Integer> mapping : fieldToClassParamIndexMap.entrySet()) {
                    if (!mapping.getKey().equals(i)) continue;
                    typeParameters.set(i, fieldTypeParameters.get(mapping.getValue()));
                }
            }
            builder.addTypeParameters(typeParameters);
            specializedFieldType = builder.build();
        }
        if (fieldModel.getTypeData().equals(specializedFieldType)) {
            return fieldModel;
        }
        return new FieldModel<V>(fieldModel.getFieldName(), fieldModel.getDocumentFieldName(), specializedFieldType, null, fieldModel.getFieldSerialization(), fieldModel.useDiscriminator(), fieldModel.getFieldAccessor());
    }

    private Codec<T> getCodecFromDocument(BsonReader reader, boolean useDiscriminator, String discriminatorKey, CodecRegistry registry, DiscriminatorLookup discriminatorLookup, Codec<T> defaultCodec) {
        Codec<Object> codec = defaultCodec;
        if (useDiscriminator) {
            BsonReaderMark mark = reader.getMark();
            reader.readStartDocument();
            boolean discriminatorKeyFound = false;
            while (!discriminatorKeyFound && reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                String name = reader.readName();
                if (discriminatorKey.equals(name)) {
                    discriminatorKeyFound = true;
                    codec = registry.get(discriminatorLookup.lookup(reader.readString()));
                    continue;
                }
                reader.skipValue();
            }
            mark.reset();
        }
        return codec;
    }
}

