/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.FullDocument;
import java.util.concurrent.TimeUnit;

public final class DBCollectionChangeStreamOptions {
    private Integer batchSize;
    private Collation collation;
    private FullDocument fullDocument = Assertions.notNull("FullDocument.DEFAULT", FullDocument.DEFAULT);
    private long maxAwaitTimeMS;
    private ReadConcern readConcern;
    private ReadPreference readPreference;
    private DBObject resumeToken;

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public DBCollectionChangeStreamOptions batchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public DBCollectionChangeStreamOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public FullDocument getFullDocument() {
        return this.fullDocument;
    }

    public DBCollectionChangeStreamOptions fullDocument(FullDocument fullDocument) {
        this.fullDocument = Assertions.notNull("fullDocument", fullDocument);
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    public DBCollectionChangeStreamOptions maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public DBCollectionChangeStreamOptions readConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
        return this;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public DBCollectionChangeStreamOptions readPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    public DBObject getResumeToken() {
        return this.resumeToken;
    }

    public DBCollectionChangeStreamOptions resumeToken(DBObject resumeToken) {
        this.resumeToken = resumeToken;
        return this;
    }
}

