/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ClientSession;
import com.mongodb.MongoIterableImpl;
import com.mongodb.OperationExecutor;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListCollectionsIterable;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.ListCollectionsOperation;
import com.mongodb.operation.ReadOperation;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

final class ListCollectionsIterableImpl<TResult>
extends MongoIterableImpl<TResult>
implements ListCollectionsIterable<TResult> {
    private final String databaseName;
    private final Class<TResult> resultClass;
    private final CodecRegistry codecRegistry;
    private Bson filter;
    private long maxTimeMS;

    ListCollectionsIterableImpl(ClientSession clientSession, String databaseName, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor) {
        super(clientSession, executor, ReadConcern.DEFAULT, readPreference);
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
    }

    @Override
    public ListCollectionsIterable<TResult> filter(Bson filter) {
        Assertions.notNull("filter", filter);
        this.filter = filter;
        return this;
    }

    @Override
    public ListCollectionsIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListCollectionsIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    ReadOperation<BatchCursor<TResult>> asReadOperation() {
        return new ListCollectionsOperation<TResult>(this.databaseName, this.codecRegistry.get(this.resultClass)).filter(this.toBsonDocument(this.filter)).batchSize(this.getBatchSize() == null ? 0 : this.getBatchSize()).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    private BsonDocument toBsonDocument(Bson document) {
        return document == null ? null : document.toBsonDocument(BsonDocument.class, this.codecRegistry);
    }
}

