/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.BaseWriteCommandMessage;
import com.mongodb.connection.BulkWriteBatchCombiner;
import com.mongodb.connection.CommandProtocol;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.SessionContext;
import com.mongodb.connection.WriteCommandResultHelper;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.internal.connection.IndexMap;
import org.bson.BsonDocument;
import org.bson.codecs.BsonDocumentCodec;

abstract class WriteCommandProtocol
implements CommandProtocol<BulkWriteResult> {
    private final MongoNamespace namespace;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private final Boolean bypassDocumentValidation;
    private SessionContext sessionContext;

    WriteCommandProtocol(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation) {
        this.namespace = namespace;
        this.ordered = ordered;
        this.writeConcern = writeConcern;
        this.bypassDocumentValidation = bypassDocumentValidation;
    }

    public WriteCommandProtocol sessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        return this;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    @Override
    public BulkWriteResult execute(InternalConnection connection) {
        BaseWriteCommandMessage nextMessage;
        BaseWriteCommandMessage message = this.createRequestMessage(ProtocolHelper.getMessageSettings(connection.getDescription()));
        BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(connection.getDescription().getServerAddress(), this.ordered, this.writeConcern);
        int batchNum = 1;
        int currentRangeStartIndex = 0;
        do {
            nextMessage = null;
            ++batchNum;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(String.format("Sending batch %d", batchNum));
            }
            BsonDocument result = connection.sendAndReceive(message, new BsonDocumentCodec(), this.sessionContext);
            nextMessage = (BaseWriteCommandMessage)message.getEncodingMetadata().getNextMessage();
            int itemCount = nextMessage != null ? message.getItemCount() - nextMessage.getItemCount() : message.getItemCount();
            IndexMap indexMap = IndexMap.create(currentRangeStartIndex, itemCount);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(String.format("Received response for batch %d", batchNum));
            }
            if (this.writeConcern.isAcknowledged()) {
                if (WriteCommandResultHelper.hasError(result)) {
                    MongoBulkWriteException bulkWriteException = WriteCommandResultHelper.getBulkWriteException(this.getType(), result, connection.getDescription().getServerAddress());
                    bulkWriteBatchCombiner.addErrorResult(bulkWriteException, indexMap);
                } else {
                    bulkWriteBatchCombiner.addResult(WriteCommandResultHelper.getBulkWriteResult(this.getType(), result), indexMap);
                }
            }
            currentRangeStartIndex += itemCount;
        } while ((message = nextMessage) != null && !bulkWriteBatchCombiner.shouldStopSendingMoreBatches());
        return bulkWriteBatchCombiner.getResult();
    }

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<BulkWriteResult> callback) {
        this.executeBatchesAsync(connection, this.createRequestMessage(ProtocolHelper.getMessageSettings(connection.getDescription())), new BulkWriteBatchCombiner(connection.getDescription().getServerAddress(), this.ordered, this.writeConcern), 1, 0, callback);
    }

    private void executeBatchesAsync(final InternalConnection connection, final BaseWriteCommandMessage message, final BulkWriteBatchCombiner bulkWriteBatchCombiner, final int batchNum, final int currentRangeStartIndex, final SingleResultCallback<BulkWriteResult> callback) {
        try {
            if (message != null && !bulkWriteBatchCombiner.shouldStopSendingMoreBatches()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(String.format("Asynchronously sending batch %d", batchNum));
                }
                connection.sendAndReceiveAsync(message, new BsonDocumentCodec(), this.sessionContext, new SingleResultCallback<BsonDocument>(){

                    @Override
                    public void onResult(BsonDocument result, Throwable t) {
                        if (t != null) {
                            callback.onResult(null, t);
                        } else {
                            BaseWriteCommandMessage nextMessage;
                            if (WriteCommandProtocol.this.getLogger().isDebugEnabled()) {
                                WriteCommandProtocol.this.getLogger().debug(String.format("Asynchronously received response for batch %d", batchNum));
                            }
                            int itemCount = (nextMessage = (BaseWriteCommandMessage)message.getEncodingMetadata().getNextMessage()) != null ? message.getItemCount() - nextMessage.getItemCount() : message.getItemCount();
                            IndexMap indexMap = IndexMap.create(currentRangeStartIndex, itemCount);
                            if (WriteCommandProtocol.this.writeConcern.isAcknowledged()) {
                                if (WriteCommandResultHelper.hasError(result)) {
                                    bulkWriteBatchCombiner.addErrorResult(WriteCommandResultHelper.getBulkWriteException(WriteCommandProtocol.this.getType(), result, connection.getDescription().getServerAddress()), indexMap);
                                } else {
                                    bulkWriteBatchCombiner.addResult(WriteCommandResultHelper.getBulkWriteResult(WriteCommandProtocol.this.getType(), result), indexMap);
                                }
                            }
                            WriteCommandProtocol.this.executeBatchesAsync(connection, nextMessage, bulkWriteBatchCombiner, batchNum + 1, currentRangeStartIndex + itemCount, callback);
                        }
                    }
                });
            } else if (bulkWriteBatchCombiner.hasErrors()) {
                callback.onResult(null, bulkWriteBatchCombiner.getError());
            } else {
                callback.onResult(bulkWriteBatchCombiner.getResult(), null);
            }
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    protected abstract WriteRequest.Type getType();

    protected abstract BaseWriteCommandMessage createRequestMessage(MessageSettings var1);

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    protected abstract Logger getLogger();

    protected boolean isOrdered() {
        return this.ordered;
    }
}

