/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoInternalException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.internal.MongoClientDelegate;
import com.mongodb.internal.session.BaseClientSessionImpl;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.operation.AbortTransactionOperation;
import com.mongodb.operation.CommitTransactionOperation;

final class ClientSessionImpl
extends BaseClientSessionImpl
implements ClientSession {
    private final MongoClientDelegate delegate;
    private boolean inTransaction;
    private boolean messageSent;
    private TransactionOptions transactionOptions;

    ClientSessionImpl(ServerSessionPool serverSessionPool, Object originator, ClientSessionOptions options, MongoClientDelegate delegate) {
        super(serverSessionPool, originator, options);
        this.delegate = delegate;
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.inTransaction;
    }

    @Override
    public boolean notifyMessageSent() {
        boolean firstMessage = !this.messageSent;
        this.messageSent = true;
        return firstMessage;
    }

    @Override
    public TransactionOptions getTransactionOptions() {
        Assertions.isTrue("in transaction", this.inTransaction);
        return this.transactionOptions;
    }

    @Override
    public void startTransaction() {
        this.startTransaction(TransactionOptions.builder().build());
    }

    @Override
    public void startTransaction(TransactionOptions transactionOptions) {
        Assertions.notNull("transactionOptions", transactionOptions);
        if (this.inTransaction) {
            throw new IllegalStateException("Transaction already in progress");
        }
        this.inTransaction = true;
        this.transactionOptions = TransactionOptions.merge(transactionOptions, this.getOptions().getDefaultTransactionOptions());
    }

    @Override
    public void commitTransaction() {
        if (this.canCommitOrAbort()) {
            throw new IllegalStateException("There is no transaction started");
        }
        try {
            if (this.messageSent) {
                ReadConcern readConcern = this.transactionOptions.getReadConcern();
                if (readConcern == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
                }
                this.delegate.getOperationExecutor().execute(new CommitTransactionOperation(this.transactionOptions.getWriteConcern()), ReadPreference.primary(), readConcern, this);
            }
        }
        finally {
            this.cleanupTransaction();
        }
    }

    @Override
    public void abortTransaction() {
        if (this.canCommitOrAbort()) {
            throw new IllegalStateException("There is no transaction started");
        }
        try {
            if (this.messageSent) {
                ReadConcern readConcern = this.transactionOptions.getReadConcern();
                if (readConcern == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
                }
                this.delegate.getOperationExecutor().execute(new AbortTransactionOperation(this.transactionOptions.getWriteConcern()), ReadPreference.primary(), readConcern, this);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.cleanupTransaction();
        }
    }

    @Override
    public void close() {
        try {
            if (this.inTransaction) {
                this.abortTransaction();
            }
        }
        finally {
            super.close();
        }
    }

    private boolean canCommitOrAbort() {
        return !this.inTransaction && !this.getOptions().getAutoStartTransaction();
    }

    private void cleanupTransaction() {
        this.inTransaction = false;
        this.messageSent = false;
        this.transactionOptions = null;
        this.getServerSession().advanceTransactionNumber();
    }
}

