/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoSocketOpenException;
import com.mongodb.MongoSocketReadException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.BufferProvider;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.Stream;
import com.mongodb.internal.connection.AsyncWritableByteChannel;
import com.mongodb.internal.connection.FutureAsyncCompletionHandler;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.ByteBuf;

public final class AsynchronousSocketChannelStream
implements Stream {
    private final ServerAddress serverAddress;
    private final SocketSettings settings;
    private final BufferProvider bufferProvider;
    private final AsynchronousChannelGroup group;
    private volatile AsynchronousSocketChannel channel;
    private volatile boolean isClosed;

    public AsynchronousSocketChannelStream(ServerAddress serverAddress, SocketSettings settings, BufferProvider bufferProvider, AsynchronousChannelGroup group) {
        this.serverAddress = serverAddress;
        this.settings = settings;
        this.bufferProvider = bufferProvider;
        this.group = group;
    }

    @Override
    public ByteBuf getBuffer(int size) {
        return this.bufferProvider.getBuffer(size);
    }

    @Override
    public void open() throws IOException {
        FutureAsyncCompletionHandler<Void> handler = new FutureAsyncCompletionHandler<Void>();
        this.openAsync(handler);
        handler.getOpen();
    }

    @Override
    public void openAsync(AsyncCompletionHandler<Void> handler) {
        Assertions.isTrue("unopened", this.channel == null);
        try {
            this.channel = AsynchronousSocketChannel.open(this.group);
            this.channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)this.settings.isKeepAlive());
            if (this.settings.getReceiveBufferSize() > 0) {
                this.channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.settings.getReceiveBufferSize());
            }
            if (this.settings.getSendBufferSize() > 0) {
                this.channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.settings.getSendBufferSize());
            }
            this.channel.connect(this.serverAddress.getSocketAddress(), null, new OpenCompletionHandler(handler));
        }
        catch (IOException e) {
            handler.failed(new MongoSocketOpenException("Exception opening socket", this.serverAddress, (Throwable)e));
        }
        catch (Throwable t) {
            handler.failed(t);
        }
    }

    @Override
    public void write(List<ByteBuf> buffers) throws IOException {
        FutureAsyncCompletionHandler<Void> handler = new FutureAsyncCompletionHandler<Void>();
        this.writeAsync(buffers, handler);
        handler.getWrite();
    }

    @Override
    public ByteBuf read(int numBytes) throws IOException {
        FutureAsyncCompletionHandler<ByteBuf> handler = new FutureAsyncCompletionHandler<ByteBuf>();
        this.readAsync(numBytes, handler);
        return handler.getRead();
    }

    @Override
    public void writeAsync(List<ByteBuf> buffers, final AsyncCompletionHandler<Void> handler) {
        final AsyncWritableByteChannelAdapter byteChannel = new AsyncWritableByteChannelAdapter();
        final Iterator<ByteBuf> iter = buffers.iterator();
        this.pipeOneBuffer(byteChannel, iter.next(), new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(Void t) {
                if (iter.hasNext()) {
                    AsynchronousSocketChannelStream.this.pipeOneBuffer(byteChannel, (ByteBuf)iter.next(), this);
                } else {
                    handler.completed(null);
                }
            }

            @Override
            public void failed(Throwable t) {
                handler.failed(t);
            }
        });
    }

    @Override
    public void readAsync(int numBytes, AsyncCompletionHandler<ByteBuf> handler) {
        ByteBuf buffer = this.bufferProvider.getBuffer(numBytes);
        this.channel.read(buffer.asNIO(), this.settings.getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, null, new BasicCompletionHandler(buffer, handler));
    }

    @Override
    public ServerAddress getAddress() {
        return this.serverAddress;
    }

    @Override
    public void close() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.channel = null;
            this.isClosed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public SocketSettings getSettings() {
        return this.settings;
    }

    public AsynchronousChannelGroup getGroup() {
        return this.group;
    }

    private void pipeOneBuffer(final AsyncWritableByteChannel byteChannel, final ByteBuf byteBuffer, final AsyncCompletionHandler<Void> outerHandler) {
        byteChannel.write(byteBuffer.asNIO(), new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(Void t) {
                if (byteBuffer.hasRemaining()) {
                    byteChannel.write(byteBuffer.asNIO(), this);
                } else {
                    outerHandler.completed(null);
                }
            }

            @Override
            public void failed(Throwable t) {
                outerHandler.failed(t);
            }
        });
    }

    private static abstract class BaseCompletionHandler<T, V, A>
    implements CompletionHandler<V, A> {
        private final AtomicReference<AsyncCompletionHandler<T>> handlerReference;

        BaseCompletionHandler(AsyncCompletionHandler<T> handler) {
            this.handlerReference = new AtomicReference<AsyncCompletionHandler<T>>(handler);
        }

        protected AsyncCompletionHandler<T> getHandlerAndClear() {
            return this.handlerReference.getAndSet(null);
        }
    }

    private class OpenCompletionHandler
    extends BaseCompletionHandler<Void, Void, Object> {
        OpenCompletionHandler(AsyncCompletionHandler<Void> handler) {
            super(handler);
        }

        @Override
        public void completed(Void result, Object attachment) {
            AsyncCompletionHandler<Object> localHandler = this.getHandlerAndClear();
            localHandler.completed(null);
        }

        @Override
        public void failed(Throwable exc, Object attachment) {
            AsyncCompletionHandler localHandler = this.getHandlerAndClear();
            if (exc instanceof IOException) {
                localHandler.failed(new MongoSocketOpenException("Exception opening socket", AsynchronousSocketChannelStream.this.getAddress(), exc));
            } else {
                localHandler.failed(exc);
            }
        }
    }

    private final class BasicCompletionHandler
    extends BaseCompletionHandler<ByteBuf, Integer, Void> {
        private final AtomicReference<ByteBuf> byteBufReference;

        private BasicCompletionHandler(ByteBuf dst, AsyncCompletionHandler<ByteBuf> handler) {
            super(handler);
            this.byteBufReference = new AtomicReference<ByteBuf>(dst);
        }

        @Override
        public void completed(Integer result, Void attachment) {
            AsyncCompletionHandler<ByteBuf> localHandler = this.getHandlerAndClear();
            ByteBuf localByteBuf = this.byteBufReference.getAndSet(null);
            if (result == -1) {
                localByteBuf.release();
                localHandler.failed(new MongoSocketReadException("Prematurely reached end of stream", AsynchronousSocketChannelStream.this.serverAddress));
            } else if (!localByteBuf.hasRemaining()) {
                localByteBuf.flip();
                localHandler.completed(localByteBuf);
            } else {
                AsynchronousSocketChannelStream.this.channel.read(localByteBuf.asNIO(), AsynchronousSocketChannelStream.this.settings.getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, null, new BasicCompletionHandler(localByteBuf, localHandler));
            }
        }

        @Override
        public void failed(Throwable t, Void attachment) {
            AsyncCompletionHandler localHandler = this.getHandlerAndClear();
            ByteBuf localByteBuf = this.byteBufReference.getAndSet(null);
            localByteBuf.release();
            if (t instanceof InterruptedByTimeoutException) {
                localHandler.failed(new MongoSocketReadTimeoutException("Timeout while receiving message", AsynchronousSocketChannelStream.this.serverAddress, t));
            } else {
                localHandler.failed(t);
            }
        }
    }

    private class AsyncWritableByteChannelAdapter
    implements AsyncWritableByteChannel {
        private AsyncWritableByteChannelAdapter() {
        }

        @Override
        public void write(ByteBuffer src, AsyncCompletionHandler<Void> handler) {
            AsynchronousSocketChannelStream.this.channel.write(src, null, new WriteCompletionHandler(handler));
        }

        private class WriteCompletionHandler
        extends BaseCompletionHandler<Void, Integer, Object> {
            WriteCompletionHandler(AsyncCompletionHandler<Void> handler) {
                super(handler);
            }

            @Override
            public void completed(Integer result, Object attachment) {
                AsyncCompletionHandler<Object> localHandler = this.getHandlerAndClear();
                localHandler.completed(null);
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                AsyncCompletionHandler localHandler = this.getHandlerAndClear();
                localHandler.failed(exc);
            }
        }
    }
}

