/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.protocol.shared.ServiceConfiguration;

public class ChangePasswordConfiguration
extends ServiceConfiguration {
    private static final long serialVersionUID = 3509208713288140629L;
    private static final String PRINCIPAL_KEY = "principal";
    private static final String DEFAULT_PRINCIPAL = "kadmin/changepw@EXAMPLE.COM";
    private static final String REALM_KEY = "realm";
    private static final String DEFAULT_REALM = "EXAMPLE.COM";
    private static final String DEFAULT_IP_PORT = "464";
    private static final String ENCRYPTION_TYPES_KEY = "encryption.types";
    public static final String[] DEFAULT_ENCRYPTION_TYPES = new String[]{"des-cbc-md5"};
    private static final String ALLOWABLE_CLOCKSKEW_KEY = "allowable.clockskew";
    private static final long DEFAULT_ALLOWABLE_CLOCKSKEW = 300000L;
    private static final String EMPTY_ADDRESSES_ALLOWED_KEY = "empty.addresses.allowed";
    private static final boolean DEFAULT_EMPTY_ADDRESSES_ALLOWED = true;
    public static final String PASSWORD_LENGTH_KEY = "password.length";
    public static final String CATEGORY_COUNT_KEY = "category.count";
    public static final String TOKEN_SIZE_KEY = "token.size";
    public static final int DEFAULT_PASSWORD_LENGTH = 6;
    public static final int DEFAULT_CATEGORY_COUNT = 3;
    public static final int DEFAULT_TOKEN_SIZE = 3;
    private static final String DEFAULT_PID = "org.apache.changepw";
    private static final String DEFAULT_NAME = "Apache Change Password Service";
    private static final String DEFAULT_PREFIX = "changepw.";
    private EncryptionType[] encryptionTypes;

    public ChangePasswordConfiguration() {
        this(ChangePasswordConfiguration.getDefaultConfig(), 1);
    }

    public ChangePasswordConfiguration(String instanceId) {
        this(ChangePasswordConfiguration.getDefaultConfig(), 1);
        this.setInstanceId(instanceId);
    }

    public ChangePasswordConfiguration(Map properties) {
        this(properties, 1);
    }

    public ChangePasswordConfiguration(Map properties, int strategy) {
        if (properties == null) {
            this.configuration = ChangePasswordConfiguration.getDefaultConfig();
        } else {
            this.loadProperties(DEFAULT_PREFIX, properties, strategy);
        }
        int port = this.getPort();
        if (port < 1 || port > 65535) {
            throw new ConfigurationException("Invalid value:  ipPort=" + port);
        }
        this.prepareEncryptionTypes();
    }

    public static Map getDefaultConfig() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("service.pid", DEFAULT_PID);
        defaults.put("ipPort", DEFAULT_IP_PORT);
        return defaults;
    }

    public boolean isDifferent(Dictionary config) {
        int port = this.getPort();
        return port != Integer.parseInt((String)config.get("ipPort"));
    }

    public String getName() {
        return DEFAULT_NAME;
    }

    public int getPort() {
        String key = "ipPort";
        if (this.configuration.containsKey(key)) {
            return Integer.parseInt(this.get(key));
        }
        return Integer.parseInt(DEFAULT_IP_PORT);
    }

    public String getPrimaryRealm() {
        String key = REALM_KEY;
        if (this.configuration.containsKey(key)) {
            return this.get(key);
        }
        return DEFAULT_REALM;
    }

    public EncryptionType[] getEncryptionTypes() {
        return this.encryptionTypes;
    }

    public Map getProperties() {
        this.configuration.put("java.naming.ldap.attributes.binary", "krb5Key");
        return this.configuration;
    }

    public long getClockSkew() {
        String key = ALLOWABLE_CLOCKSKEW_KEY;
        if (this.configuration.containsKey(key)) {
            return 60000L * Long.parseLong(this.get(key));
        }
        return 300000L;
    }

    public int getBufferSize() {
        String key = "buffer.size";
        if (this.configuration.containsKey(key)) {
            return Integer.parseInt(this.get(key));
        }
        return 1024;
    }

    public KerberosPrincipal getChangepwPrincipal() {
        String key = PRINCIPAL_KEY;
        if (this.configuration.containsKey(key)) {
            return new KerberosPrincipal(this.get(key));
        }
        return new KerberosPrincipal(DEFAULT_PRINCIPAL);
    }

    public boolean isEmptyAddressesAllowed() {
        String key = EMPTY_ADDRESSES_ALLOWED_KEY;
        if (this.configuration.containsKey(key)) {
            return "true".equalsIgnoreCase(this.get(key));
        }
        return true;
    }

    public int getPasswordLengthPolicy() {
        String key = PASSWORD_LENGTH_KEY;
        if (this.configuration.containsKey(key)) {
            return Integer.parseInt(this.get(key));
        }
        return 6;
    }

    public int getCategoryCountPolicy() {
        String key = CATEGORY_COUNT_KEY;
        if (this.configuration.containsKey(key)) {
            return Integer.parseInt(this.get(key));
        }
        return 3;
    }

    public int getTokenSizePolicy() {
        String key = TOKEN_SIZE_KEY;
        if (this.configuration.containsKey(key)) {
            return Integer.parseInt(this.get(key));
        }
        return 3;
    }

    private void prepareEncryptionTypes() {
        String[] encryptionTypeStrings = null;
        String key = ENCRYPTION_TYPES_KEY;
        encryptionTypeStrings = this.configuration.containsKey(key) ? this.get(key).split("\\s") : DEFAULT_ENCRYPTION_TYPES;
        ArrayList<EncryptionType> encTypes = new ArrayList<EncryptionType>();
        for (int ii = 0; ii < encryptionTypeStrings.length; ++ii) {
            String enc = encryptionTypeStrings[ii];
            Iterator it = EncryptionType.VALUES.iterator();
            while (it.hasNext()) {
                EncryptionType type = (EncryptionType)it.next();
                if (!type.toString().equalsIgnoreCase(enc)) continue;
                encTypes.add(type);
            }
        }
        this.encryptionTypes = encTypes.toArray(new EncryptionType[encTypes.size()]);
    }
}

