/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw.service;

import java.net.InetAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.changepw.service.ChangePasswordContext;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddress;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorContext
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger((Class)MonitorContext.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        if (log.isDebugEnabled()) {
            try {
                ChangePasswordContext changepwContext = (ChangePasswordContext)((Object)session.getAttribute(this.getContextKey()));
                PrincipalStore store = changepwContext.getStore();
                ApplicationRequest authHeader = changepwContext.getAuthHeader();
                Ticket ticket = changepwContext.getTicket();
                ReplayCache replayCache = changepwContext.getReplayCache();
                long clockSkew = changepwContext.getConfig().getClockSkew();
                Authenticator authenticator = changepwContext.getAuthenticator();
                KerberosPrincipal clientPrincipal = authenticator.getClientPrincipal();
                String desiredPassword = changepwContext.getPassword();
                InetAddress clientAddress = changepwContext.getClientAddress();
                HostAddresses clientAddresses = ticket.getClientAddresses();
                boolean caddrContainsSender = false;
                if (ticket.getClientAddresses() != null) {
                    caddrContainsSender = ticket.getClientAddresses().contains(new HostAddress(clientAddress));
                }
                StringBuffer sb = new StringBuffer();
                sb.append("Monitoring context:");
                sb.append("\n\tstore                  " + store);
                sb.append("\n\tauthHeader             " + authHeader);
                sb.append("\n\tticket                 " + ticket);
                sb.append("\n\treplayCache            " + replayCache);
                sb.append("\n\tclockSkew              " + clockSkew);
                sb.append("\n\tclientPrincipal        " + clientPrincipal);
                sb.append("\n\tdesiredPassword        " + desiredPassword);
                sb.append("\n\tclientAddress          " + clientAddress);
                sb.append("\n\tclientAddresses        " + clientAddresses);
                sb.append("\n\tcaddr contains sender  " + caddrContainsSender);
                KerberosPrincipal ticketServerPrincipal = ticket.getServerPrincipal();
                PrincipalStoreEntry ticketPrincipal = changepwContext.getServerEntry();
                sb.append("\n\tprincipal              " + ticketServerPrincipal);
                sb.append("\n\tcn                     " + ticketPrincipal.getCommonName());
                sb.append("\n\trealm                  " + ticketPrincipal.getRealmName());
                sb.append("\n\tprincipal              " + ticketPrincipal.getPrincipal());
                sb.append("\n\tSAM type               " + ticketPrincipal.getSamType());
                sb.append("\n\tKey type               " + ticketPrincipal.getEncryptionKey().getKeyType());
                sb.append("\n\tKey version            " + ticketPrincipal.getEncryptionKey().getKeyVersion());
                log.debug(sb.toString());
            }
            catch (Exception e) {
                log.error("Error in context monitor", (Throwable)e);
            }
        }
        next.execute(session, message);
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

