/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.builder;

import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.MTOMConstants;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.XOPBuilder;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;

public class MTOMStAXSOAPModelBuilder
extends StAXSOAPModelBuilder
implements MTOMConstants,
XOPBuilder {
    Attachments attachments;
    int partIndex = 0;

    public MTOMStAXSOAPModelBuilder(XMLStreamReader parser, SOAPFactory factory, Attachments attachments, String soapVersion) {
        super(parser, factory, soapVersion);
        this.attachments = attachments;
    }

    public MTOMStAXSOAPModelBuilder(XMLStreamReader reader, Attachments attachments, String soapVersion) {
        super(reader, soapVersion);
        this.attachments = attachments;
    }

    public MTOMStAXSOAPModelBuilder(XMLStreamReader reader, Attachments attachments) {
        super(reader);
        this.attachments = attachments;
    }

    protected OMNode createOMElement() throws OMException {
        String elementName = this.parser.getLocalName();
        String namespaceURI = this.parser.getNamespaceURI();
        if ("Include".equals(elementName) && "http://www.w3.org/2004/08/xop/include".equals(namespaceURI)) {
            OMText node;
            String contentID = ElementHelper.getContentID(this.parser, this.getDocument().getCharsetEncoding());
            if (this.lastNode == null) {
                throw new OMException("XOP:Include element is not supported here");
            }
            if (this.lastNode.isComplete() & this.lastNode.getParent() != null) {
                node = this.omfactory.createOMText(contentID, this.lastNode.getParent(), this);
                ((OMNodeEx)this.lastNode).setNextOMSibling(node);
                ((OMNodeEx)((Object)node)).setPreviousOMSibling(this.lastNode);
            } else {
                OMContainerEx e = (OMContainerEx)((Object)this.lastNode);
                node = this.omfactory.createOMText(contentID, (OMElement)this.lastNode, this);
                e.setFirstChild(node);
            }
            return node;
        }
        return super.createOMElement();
    }

    public DataHandler getDataHandler(String blobContentID) throws OMException {
        DataHandler dataHandler = this.attachments.getDataHandler(blobContentID);
        if (dataHandler == null) {
            throw new OMException("Referenced Attachment not found in the MIME Message. ContentID:" + blobContentID);
        }
        return dataHandler;
    }
}

