/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.combine;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Rule;
import com.sun.xacml.combine.RuleCombiningAlgorithm;
import com.sun.xacml.ctx.Result;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;

public class PermitOverridesRuleAlg
extends RuleCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:permit-overrides";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    public PermitOverridesRuleAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    protected PermitOverridesRuleAlg(URI identifier) {
        super(identifier);
    }

    public Result combine(EvaluationCtx context, List rules) {
        boolean atLeastOneError = false;
        boolean potentialPermit = false;
        boolean atLeastOneDeny = false;
        Result firstIndeterminateResult = null;
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            Rule rule = (Rule)it.next();
            Result result = rule.evaluate(context);
            int value = result.getDecision();
            if (value == 0) {
                return result;
            }
            if (value == 2) {
                atLeastOneError = true;
                if (firstIndeterminateResult == null) {
                    firstIndeterminateResult = result;
                }
                if (rule.getEffect() != 0) continue;
                potentialPermit = true;
                continue;
            }
            if (value != 1) continue;
            atLeastOneDeny = true;
        }
        if (potentialPermit) {
            return firstIndeterminateResult;
        }
        if (atLeastOneDeny) {
            return new Result(1, context.getResourceId().encode());
        }
        if (atLeastOneError) {
            return firstIndeterminateResult;
        }
        return new Result(3, context.getResourceId().encode());
    }

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }
}

