/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeDesignator;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeSelector;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.FunctionTypeException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Apply
implements Evaluatable {
    private Function function;
    private List evals;
    private Function bagFunction;
    private boolean isCondition;

    public Apply(Function function, List evals, boolean isCondition) throws IllegalArgumentException {
        this(function, evals, null, isCondition);
    }

    public Apply(Function function, List evals, Function bagFunction, boolean isCondition) throws IllegalArgumentException {
        ArrayList<Function> inputs = evals;
        if (bagFunction != null) {
            inputs = new ArrayList<Function>();
            inputs.add(bagFunction);
            inputs.addAll(evals);
        }
        function.checkInputs(inputs);
        this.function = function;
        this.evals = Collections.unmodifiableList(new ArrayList(evals));
        this.bagFunction = bagFunction;
        this.isCondition = isCondition;
    }

    public static Apply getConditionInstance(Node root, String xpathVersion) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getConditionInstance(), true, xpathVersion);
    }

    public static Apply getInstance(Node root, String xpathVersion) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getGeneralInstance(), false, xpathVersion);
    }

    private static Apply getInstance(Node root, FunctionFactory factory, boolean isCondition, String xpathVersion) throws ParsingException {
        Function function = Apply.getFunction(root, xpathVersion, factory);
        Function bagFunction = null;
        ArrayList<Evaluatable> evals = new ArrayList<Evaluatable>();
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("Apply")) {
                evals.add(Apply.getInstance(node, xpathVersion));
                continue;
            }
            if (name.equals("AttributeValue")) {
                try {
                    evals.add(attrFactory.createValue(node));
                    continue;
                }
                catch (UnknownIdentifierException uie) {
                    throw new ParsingException("Unknown DataType", uie);
                }
            }
            if (name.equals("SubjectAttributeDesignator")) {
                evals.add(AttributeDesignator.getInstance(node, 0));
                continue;
            }
            if (name.equals("ResourceAttributeDesignator")) {
                evals.add(AttributeDesignator.getInstance(node, 1));
                continue;
            }
            if (name.equals("ActionAttributeDesignator")) {
                evals.add(AttributeDesignator.getInstance(node, 2));
                continue;
            }
            if (name.equals("EnvironmentAttributeDesignator")) {
                evals.add(AttributeDesignator.getInstance(node, 3));
                continue;
            }
            if (name.equals("AttributeSelector")) {
                evals.add(AttributeSelector.getInstance(node, xpathVersion));
                continue;
            }
            if (!name.equals("Function")) continue;
            if (bagFunction != null) {
                throw new ParsingException("Too many FunctionTypes");
            }
            bagFunction = Apply.getFunction(node, xpathVersion, FunctionFactory.getGeneralInstance());
        }
        return new Apply(function, evals, bagFunction, isCondition);
    }

    private static Function getFunction(Node root, String version, FunctionFactory factory) throws ParsingException {
        Node functionNode = root.getAttributes().getNamedItem("FunctionId");
        String functionName = functionNode.getNodeValue();
        try {
            return factory.createFunction(functionName);
        }
        catch (UnknownIdentifierException uie) {
            throw new ParsingException("Unknown FunctionId in Apply", uie);
        }
        catch (FunctionTypeException fte) {
            try {
                FunctionFactory ff = FunctionFactory.getGeneralInstance();
                return ff.createAbstractFunction(functionName, root, version);
            }
            catch (Exception e) {
                throw new ParsingException("failed to create abstract function " + functionName, e);
            }
        }
    }

    public Function getFunction() {
        return this.function;
    }

    public List getChildren() {
        return this.evals;
    }

    public Function getHigherOrderFunction() {
        return this.bagFunction;
    }

    public boolean isCondition() {
        return this.isCondition;
    }

    public EvaluationResult evaluate(EvaluationCtx context) {
        ArrayList<Object> parameters = this.evals;
        if (this.bagFunction != null) {
            parameters = new ArrayList<Object>();
            parameters.add(this.bagFunction);
            Iterator it = this.evals.iterator();
            while (it.hasNext()) {
                Evaluatable eval = (Evaluatable)it.next();
                EvaluationResult result = eval.evaluate(context);
                if (result.indeterminate()) {
                    return result;
                }
                parameters.add(result.getAttributeValue());
            }
        }
        return this.function.evaluate(parameters, context);
    }

    public URI getType() {
        return this.function.getReturnType();
    }

    public boolean evaluatesToBag() {
        return this.function.returnsBag();
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        if (this.isCondition) {
            out.println(indent + "<Condition FunctionId=\"" + this.function.getIdentifier() + "\">");
        } else {
            out.println(indent + "<Apply FunctionId=\"" + this.function.getIdentifier() + "\">");
        }
        indenter.in();
        if (this.bagFunction != null) {
            out.println("<Function FunctionId=\"" + this.bagFunction.getIdentifier() + "\"/>");
        }
        Iterator it = this.evals.iterator();
        while (it.hasNext()) {
            Evaluatable eval = (Evaluatable)it.next();
            eval.encode(output, indenter);
        }
        indenter.out();
        if (this.isCondition) {
            out.println(indent + "</Condition>");
        } else {
            out.println(indent + "</Apply>");
        }
    }
}

