/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.StatusDetail;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Status {
    public static final String STATUS_OK = "urn:oasis:names:tc:xacml:1.0:status:ok";
    public static final String STATUS_MISSING_ATTRIBUTE = "urn:oasis:names:tc:xacml:1.0:status:missing-attribute";
    public static final String STATUS_SYNTAX_ERROR = "urn:oasis:names:tc:xacml:1.0:status:syntax-error";
    public static final String STATUS_PROCESSING_ERROR = "urn:oasis:names:tc:xacml:1.0:status:processing-error";
    private List code;
    private String message;
    private StatusDetail detail;
    private static Status okStatus;

    public Status(List code) {
        this(code, null, null);
    }

    public Status(List code, String message) {
        this(code, message, null);
    }

    public Status(List code, String message, StatusDetail detail) throws IllegalArgumentException {
        String c;
        if (detail != null && ((c = (String)code.iterator().next()).equals(STATUS_OK) || c.equals(STATUS_SYNTAX_ERROR) || c.equals(STATUS_PROCESSING_ERROR))) {
            throw new IllegalArgumentException("status detail cannot be included with " + c);
        }
        this.code = Collections.unmodifiableList(new ArrayList(code));
        this.message = message;
        this.detail = detail;
    }

    public List getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public StatusDetail getDetail() {
        return this.detail;
    }

    public static Status getOkInstance() {
        return okStatus;
    }

    public static Status getInstance(Node root) throws ParsingException {
        List code = null;
        String message = null;
        StatusDetail detail = null;
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("StatusCode")) {
                code = Status.parseStatusCode(node);
                continue;
            }
            if (name.equals("StatusMessage")) {
                message = node.getFirstChild().getNodeValue();
                continue;
            }
            if (!name.equals("StatusDetail")) continue;
            detail = StatusDetail.getInstance(node);
        }
        return new Status(code, message, detail);
    }

    private static List parseStatusCode(Node root) {
        String val = root.getAttributes().getNamedItem("Value").getNodeValue();
        ArrayList<String> code = new ArrayList<String>();
        code.add(val);
        NodeList list = ((Element)root).getElementsByTagName("StatusCode");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            code.add(node.getAttributes().getNamedItem("Value").getNodeValue());
        }
        return code;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<Status>");
        indenter.in();
        this.encodeStatusCode(out, indenter, this.code.iterator());
        if (this.message != null) {
            out.println(indenter.makeString() + "<StatusMessage>" + this.message + "</StatusMessage>");
        }
        if (this.detail != null) {
            out.println(this.detail.getEncoded());
        }
        indenter.out();
        out.println(indent + "</Status>");
    }

    private void encodeStatusCode(PrintStream out, Indenter indenter, Iterator iterator) {
        String in = indenter.makeString();
        String code = (String)iterator.next();
        if (iterator.hasNext()) {
            indenter.in();
            out.println(in + "<StatusCode Value=\"" + code + "\">");
            this.encodeStatusCode(out, indenter, iterator);
            out.println(in + "</StatusCode>");
            indenter.out();
        } else {
            out.println(in + "<StatusCode Value=\"" + code + "\"/>");
        }
    }

    static {
        ArrayList<String> code = new ArrayList<String>();
        code.add(STATUS_OK);
        okStatus = new Status(code);
    }
}

