/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils;

import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jaitools.CollectionFactory;
import org.jaitools.imageutils.ImageSet;
import org.jaitools.imageutils.SimpleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageSetIterator<K> {
    private final List<K> keys;
    private final List<SimpleIterator> delegates;

    ImageSetIterator(ImageSet set, Rectangle bounds) {
        if (set == null || set.isEmpty()) {
            throw new IllegalArgumentException("The ImageSet must not be null or empty");
        }
        this.keys = CollectionFactory.list();
        this.delegates = CollectionFactory.list();
        Set keySet = set.keySet();
        for (Object key : keySet) {
            this.keys.add(key);
            this.delegates.add(new SimpleIterator(set.get(key), bounds, set.getOutsideValue(key)));
        }
    }

    public Map<K, Number> getSample() {
        return this.getSample(0);
    }

    public Map<K, Number> getSample(int band) {
        Map<K, Number> sample = CollectionFactory.map();
        for (int i = 0; i < this.keys.size(); ++i) {
            K key = this.keys.get(i);
            Number value = this.delegates.get(i).getSample(band);
            sample.put(key, value);
        }
        return sample;
    }

    public boolean hasNext() {
        return this.delegates.get(0).hasNext();
    }

    public boolean next() {
        if (this.hasNext()) {
            for (SimpleIterator iter : this.delegates) {
                iter.next();
            }
            return true;
        }
        return false;
    }
}

