/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.batch.item.adapter.DynamicMethodInvocationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.MethodInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodInvokingDelegator<T>
implements InitializingBean {
    private Object targetObject;
    private String targetMethod;
    private Object[] arguments;

    protected T invokeDelegateMethod() {
        MethodInvoker invoker = this.createMethodInvoker(this.targetObject, this.targetMethod);
        invoker.setArguments(this.arguments);
        return this.doInvoke(invoker);
    }

    protected T invokeDelegateMethodWithArgument(Object object) {
        MethodInvoker invoker = this.createMethodInvoker(this.targetObject, this.targetMethod);
        invoker.setArguments(new Object[]{object});
        return this.doInvoke(invoker);
    }

    protected T invokeDelegateMethodWithArguments(Object[] args) {
        MethodInvoker invoker = this.createMethodInvoker(this.targetObject, this.targetMethod);
        invoker.setArguments(args);
        return this.doInvoke(invoker);
    }

    private MethodInvoker createMethodInvoker(Object targetObject, String targetMethod) {
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetObject(targetObject);
        invoker.setTargetMethod(targetMethod);
        invoker.setArguments(this.arguments);
        return invoker;
    }

    private T doInvoke(MethodInvoker invoker) {
        try {
            invoker.prepare();
        }
        catch (ClassNotFoundException e) {
            throw new DynamicMethodInvocationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new DynamicMethodInvocationException(e);
        }
        try {
            return (T)invoker.invoke();
        }
        catch (InvocationTargetException e) {
            throw new DynamicMethodInvocationException(e);
        }
        catch (IllegalAccessException e) {
            throw new DynamicMethodInvocationException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.targetObject);
        Assert.hasLength((String)this.targetMethod);
        Assert.state((boolean)this.targetClassDeclaresTargetMethod(), (String)"target class must declare a method with matching name and parameter types");
    }

    private boolean targetClassDeclaresTargetMethod() {
        MethodInvoker invoker = this.createMethodInvoker(this.targetObject, this.targetMethod);
        Method[] memberMethods = invoker.getTargetClass().getMethods();
        Method[] declaredMethods = invoker.getTargetClass().getDeclaredMethods();
        ArrayList allMethods = new ArrayList();
        allMethods.addAll(Arrays.asList(memberMethods));
        allMethods.addAll(Arrays.asList(declaredMethods));
        String targetMethodName = invoker.getTargetMethod();
        for (Method method : allMethods) {
            if (!method.getName().equals(targetMethodName)) continue;
            Class<?>[] params = method.getParameterTypes();
            if (this.arguments == null) {
                return true;
            }
            if (this.arguments.length != params.length) continue;
            boolean argumentsMatchParameters = true;
            int j = 0;
            while (j < params.length) {
                if (this.arguments[j] != null && !params[j].isAssignableFrom(this.arguments[j].getClass())) {
                    argumentsMatchParameters = false;
                }
                ++j;
            }
            if (!argumentsMatchParameters) continue;
            return true;
        }
        return false;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }
}

