/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.adapter;

import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.adapter.AbstractMethodInvokingDelegator;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyExtractingDelegatingItemWriter<T>
extends AbstractMethodInvokingDelegator<T>
implements ItemWriter<T> {
    private String[] fieldsUsedAsTargetMethodArguments;

    @Override
    public void write(List<? extends T> items) throws Exception {
        for (T item : items) {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(item);
            Object[] methodArguments = new Object[this.fieldsUsedAsTargetMethodArguments.length];
            int i = 0;
            while (i < this.fieldsUsedAsTargetMethodArguments.length) {
                methodArguments[i] = beanWrapper.getPropertyValue(this.fieldsUsedAsTargetMethodArguments[i]);
                ++i;
            }
            this.invokeDelegateMethodWithArguments(methodArguments);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notEmpty((Object[])this.fieldsUsedAsTargetMethodArguments);
    }

    public void setFieldsUsedAsTargetMethodArguments(String[] fieldsUsedAsMethodArguments) {
        this.fieldsUsedAsTargetMethodArguments = fieldsUsedAsMethodArguments;
    }
}

