/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.jms;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.retry.interceptor.MethodInvocationRecoverer;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsMethodInvocationRecoverer<T>
implements MethodInvocationRecoverer<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private JmsOperations jmsTemplate;

    public void setJmsTemplate(JmsOperations jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    @Override
    public T recover(Object[] items, Throwable cause) {
        try {
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                this.jmsTemplate.convertAndSend(item);
                ++n2;
            }
        }
        catch (JmsException e) {
            this.logger.error((Object)"Could not recover because of JmsException.", (Throwable)e);
            throw e;
        }
        return null;
    }
}

