/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.config.http.MatcherType;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FilterInvocationSecurityMetadataSourceParser
implements BeanDefinitionParser {
    private static final String ATT_USE_EXPRESSIONS = "use-expressions";
    private static final String ATT_HTTP_METHOD = "method";
    private static final String ATT_PATTERN = "pattern";
    private static final String ATT_ACCESS = "access";
    private static final Log logger = LogFactory.getLog(FilterInvocationSecurityMetadataSourceParser.class);

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        List interceptUrls = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-url");
        for (Element elt : interceptUrls) {
            if (StringUtils.hasLength((String)elt.getAttribute("requires-channel"))) {
                parserContext.getReaderContext().error("The attribute 'requires-channel' isn't allowed here.", (Object)elt);
            }
            if (!StringUtils.hasLength((String)elt.getAttribute("filters"))) continue;
            parserContext.getReaderContext().error("The attribute 'filters' isn't allowed here.", (Object)elt);
        }
        RootBeanDefinition mds = FilterInvocationSecurityMetadataSourceParser.createSecurityMetadataSource(interceptUrls, false, element, parserContext);
        String id = element.getAttribute("id");
        if (StringUtils.hasText((String)id)) {
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)mds, id));
            parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)mds);
        }
        return mds;
    }

    static RootBeanDefinition createSecurityMetadataSource(List<Element> interceptUrls, boolean addAllAuth, Element httpElt, ParserContext pc) {
        BeanDefinitionBuilder fidsBuilder;
        MatcherType matcherType = MatcherType.fromElement(httpElt);
        boolean useExpressions = FilterInvocationSecurityMetadataSourceParser.isUseExpressions(httpElt);
        ManagedMap<BeanDefinition, BeanDefinition> requestToAttributesMap = FilterInvocationSecurityMetadataSourceParser.parseInterceptUrlsForFilterInvocationRequestMap(matcherType, interceptUrls, useExpressions, addAllAuth, pc);
        if (useExpressions) {
            String expressionHandlerRef;
            Element expressionHandlerElt = DomUtils.getChildElementByTagName((Element)httpElt, (String)"expression-handler");
            String string = expressionHandlerRef = expressionHandlerElt == null ? null : expressionHandlerElt.getAttribute("ref");
            if (StringUtils.hasText((String)expressionHandlerRef)) {
                logger.info((Object)("Using bean '" + expressionHandlerRef + "' as web SecurityExpressionHandler implementation"));
            } else {
                expressionHandlerRef = FilterInvocationSecurityMetadataSourceParser.registerDefaultExpressionHandler(pc);
            }
            fidsBuilder = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedFilterInvocationSecurityMetadataSource.class);
            fidsBuilder.addConstructorArgValue(requestToAttributesMap);
            fidsBuilder.addConstructorArgReference(expressionHandlerRef);
        } else {
            fidsBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultFilterInvocationSecurityMetadataSource.class);
            fidsBuilder.addConstructorArgValue(requestToAttributesMap);
        }
        fidsBuilder.getRawBeanDefinition().setSource(pc.extractSource((Object)httpElt));
        return (RootBeanDefinition)fidsBuilder.getBeanDefinition();
    }

    static String registerDefaultExpressionHandler(ParserContext pc) {
        AbstractBeanDefinition expressionHandler = BeanDefinitionBuilder.rootBeanDefinition(DefaultWebSecurityExpressionHandler.class).getBeanDefinition();
        String expressionHandlerRef = pc.getReaderContext().generateBeanName((BeanDefinition)expressionHandler);
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)expressionHandler, expressionHandlerRef));
        return expressionHandlerRef;
    }

    static boolean isUseExpressions(Element elt) {
        String useExpressions = elt.getAttribute(ATT_USE_EXPRESSIONS);
        return !StringUtils.hasText((String)useExpressions) || "true".equals(useExpressions);
    }

    private static ManagedMap<BeanDefinition, BeanDefinition> parseInterceptUrlsForFilterInvocationRequestMap(MatcherType matcherType, List<Element> urlElts, boolean useExpressions, boolean addAuthenticatedAll, ParserContext parserContext) {
        ManagedMap filterInvocationDefinitionMap = new ManagedMap();
        for (Element urlElt : urlElts) {
            String method;
            String access = urlElt.getAttribute(ATT_ACCESS);
            if (!StringUtils.hasText((String)access)) continue;
            String path = urlElt.getAttribute(ATT_PATTERN);
            if (!StringUtils.hasText((String)path)) {
                parserContext.getReaderContext().error("path attribute cannot be empty or null", (Object)urlElt);
            }
            if (!StringUtils.hasText((String)(method = urlElt.getAttribute(ATT_HTTP_METHOD)))) {
                method = null;
            }
            BeanDefinition matcher = matcherType.createMatcher(path, method);
            BeanDefinitionBuilder attributeBuilder = BeanDefinitionBuilder.rootBeanDefinition(SecurityConfig.class);
            if (useExpressions) {
                logger.info((Object)("Creating access control expression attribute '" + access + "' for " + path));
                attributeBuilder.addConstructorArgValue((Object)new String[]{access});
                attributeBuilder.setFactoryMethod("createList");
            } else {
                attributeBuilder.addConstructorArgValue((Object)access);
                attributeBuilder.setFactoryMethod("createListFromCommaDelimitedString");
            }
            if (filterInvocationDefinitionMap.containsKey((Object)matcher)) {
                logger.warn((Object)("Duplicate URL defined: " + path + ". The original attribute values will be overwritten"));
            }
            filterInvocationDefinitionMap.put((Object)matcher, (Object)attributeBuilder.getBeanDefinition());
        }
        if (addAuthenticatedAll && filterInvocationDefinitionMap.isEmpty()) {
            BeanDefinition matcher = matcherType.createMatcher("/**", null);
            BeanDefinitionBuilder attributeBuilder = BeanDefinitionBuilder.rootBeanDefinition(SecurityConfig.class);
            attributeBuilder.addConstructorArgValue((Object)new String[]{"authenticated"});
            attributeBuilder.setFactoryMethod("createList");
            filterInvocationDefinitionMap.put((Object)matcher, (Object)attributeBuilder.getBeanDefinition());
        }
        return filterInvocationDefinitionMap;
    }
}

