/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.web.support;

import java.util.List;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class WebTestUtils {
    private static final SecurityContextRepository DEFAULT_CONTEXT_REPO = new HttpSessionSecurityContextRepository();
    private static final CsrfTokenRepository DEFAULT_TOKEN_REPO = new HttpSessionCsrfTokenRepository();

    public static SecurityContextRepository getSecurityContextRepository(HttpServletRequest request) {
        SecurityContextPersistenceFilter filter = WebTestUtils.findFilter(request, SecurityContextPersistenceFilter.class);
        if (filter == null) {
            return DEFAULT_CONTEXT_REPO;
        }
        return (SecurityContextRepository)ReflectionTestUtils.getField((Object)filter, (String)"repo");
    }

    public static void setSecurityContextRepository(HttpServletRequest request, SecurityContextRepository securityContextRepository) {
        SecurityContextPersistenceFilter filter = WebTestUtils.findFilter(request, SecurityContextPersistenceFilter.class);
        if (filter != null) {
            ReflectionTestUtils.setField((Object)filter, (String)"repo", (Object)securityContextRepository);
        }
    }

    public static CsrfTokenRepository getCsrfTokenRepository(HttpServletRequest request) {
        CsrfFilter filter = WebTestUtils.findFilter(request, CsrfFilter.class);
        if (filter == null) {
            return DEFAULT_TOKEN_REPO;
        }
        return (CsrfTokenRepository)ReflectionTestUtils.getField((Object)filter, (String)"tokenRepository");
    }

    public static void setCsrfTokenRepository(HttpServletRequest request, CsrfTokenRepository repository) {
        CsrfFilter filter = WebTestUtils.findFilter(request, CsrfFilter.class);
        if (filter != null) {
            ReflectionTestUtils.setField((Object)filter, (String)"tokenRepository", (Object)repository);
        }
    }

    static <T extends Filter> T findFilter(HttpServletRequest request, Class<T> filterClass) {
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
        if (webApplicationContext == null) {
            return null;
        }
        Filter springSecurityFilterChain = null;
        try {
            springSecurityFilterChain = (Filter)webApplicationContext.getBean("springSecurityFilterChain", Filter.class);
        }
        catch (NoSuchBeanDefinitionException notFound) {
            return null;
        }
        List filters = (List)ReflectionTestUtils.invokeMethod((Object)springSecurityFilterChain, (String)"getFilters", (Object[])new Object[]{request});
        if (filters == null) {
            return null;
        }
        for (Filter filter : filters) {
            if (!filterClass.isAssignableFrom(filter.getClass())) continue;
            return (T)filter;
        }
        return null;
    }

    private WebTestUtils() {
    }
}

