/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.ByteString;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.StringSerializer;
import com.dyuproject.protostuff.UninitializedMessageException;
import com.dyuproject.protostuff.XmlInputException;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlInput
implements Input {
    private final XMLStreamReader parser;
    private boolean emptyMessage = false;

    public XmlInput(XMLStreamReader parser) {
        this.parser = parser;
    }

    private int next() throws IOException {
        try {
            return this.parser.next();
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
    }

    private int nextTag() throws IOException {
        try {
            return this.parser.nextTag();
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
    }

    private void endAndNextTag() throws IOException {
        try {
            this.parser.nextTag();
            this.parser.nextTag();
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
    }

    private String getText() throws IOException {
        try {
            String text = this.parser.getElementText();
            this.parser.nextTag();
            return text;
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
    }

    public <T> void handleUnknownField(int fieldNumber, Schema<T> schema) throws IOException {
        String name = this.parser.getLocalName();
        while (true) {
            switch (this.next()) {
                case 2: {
                    if (name.equals(this.parser.getLocalName())) {
                        this.nextTag();
                        return;
                    }
                    throw new XmlInputException("Unknown field: " + name + " on message " + schema.messageFullName());
                }
                case 1: 
                case 8: {
                    throw new XmlInputException("Unknown field: " + name + " on message " + schema.messageFullName());
                }
            }
        }
    }

    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        if (this.emptyMessage) {
            this.emptyMessage = false;
            return 0;
        }
        if (this.parser.getEventType() == 2) {
            return 0;
        }
        String name = this.parser.getLocalName();
        int num = schema.getFieldNumber(name);
        if (num == 0) {
            while (true) {
                switch (this.next()) {
                    case 2: {
                        if (name.equals(this.parser.getLocalName())) {
                            this.nextTag();
                            return this.readFieldNumber(schema);
                        }
                        throw new XmlInputException("Unknown field: " + name + " on message " + schema.messageFullName());
                    }
                    case 1: 
                    case 8: {
                        throw new XmlInputException("Unknown field: " + name + " on message " + schema.messageFullName());
                    }
                }
            }
        }
        return num;
    }

    public int readInt32() throws IOException {
        return Integer.parseInt(this.getText());
    }

    public int readUInt32() throws IOException {
        return Integer.parseInt(this.getText());
    }

    public int readSInt32() throws IOException {
        return Integer.parseInt(this.getText());
    }

    public int readFixed32() throws IOException {
        return Integer.parseInt(this.getText());
    }

    public int readSFixed32() throws IOException {
        return Integer.parseInt(this.getText());
    }

    public long readInt64() throws IOException {
        return Long.parseLong(this.getText());
    }

    public long readUInt64() throws IOException {
        return Long.parseLong(this.getText());
    }

    public long readSInt64() throws IOException {
        return Long.parseLong(this.getText());
    }

    public long readFixed64() throws IOException {
        return Long.parseLong(this.getText());
    }

    public long readSFixed64() throws IOException {
        return Long.parseLong(this.getText());
    }

    public float readFloat() throws IOException {
        return Float.parseFloat(this.getText());
    }

    public double readDouble() throws IOException {
        return Double.parseDouble(this.getText());
    }

    public boolean readBool() throws IOException {
        return Boolean.parseBoolean(this.getText());
    }

    public int readEnum() throws IOException {
        return Integer.parseInt(this.getText());
    }

    public String readString() throws IOException {
        return this.getText();
    }

    public ByteString readBytes() throws IOException {
        return ByteString.wrap((byte[])this.readByteArray());
    }

    public byte[] readByteArray() throws IOException {
        return StringSerializer.STRING.ser((String)this.getText());
    }

    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        if (this.nextTag() != 1 || !schema.messageName().equals(this.parser.getLocalName())) {
            throw new XmlInputException("Expecting token END_ELEMENT: " + schema.messageName());
        }
        if (this.nextTag() == 2) {
            this.emptyMessage = true;
            if (value == null) {
                value = schema.newMessage();
            }
            schema.mergeFrom((Input)this, value);
            if (!schema.isInitialized(value)) {
                throw new UninitializedMessageException(value, schema);
            }
            this.endAndNextTag();
            return value;
        }
        if (value == null) {
            value = schema.newMessage();
        }
        schema.mergeFrom((Input)this, value);
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        this.endAndNextTag();
        return value;
    }

    public void transferByteRangeTo(Output output, boolean utf8String, int fieldNumber, boolean repeated) throws IOException {
        if (utf8String) {
            output.writeString(fieldNumber, this.readString(), repeated);
        } else {
            output.writeByteArray(fieldNumber, this.readByteArray(), repeated);
        }
    }
}

