/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.ByteString;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.StatefulOutput;
import com.dyuproject.protostuff.StringSerializer;
import com.dyuproject.protostuff.XmlOutputException;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlOutput
implements Output,
StatefulOutput {
    private final XMLStreamWriter writer;
    private Schema<?> schema;

    public XmlOutput(XMLStreamWriter writer) {
        this(writer, null);
    }

    public XmlOutput(XMLStreamWriter writer, Schema<?> schema) {
        this.writer = writer;
        this.schema = schema;
    }

    public XmlOutput use(Schema<?> schema) {
        this.schema = schema;
        return this;
    }

    public void updateLast(Schema<?> schema, Schema<?> lastSchema) {
        if (lastSchema != null && lastSchema == this.schema) {
            this.schema = schema;
        }
    }

    private static void write(XMLStreamWriter writer, String name, String value) throws IOException {
        try {
            writer.writeStartElement(name);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlOutputException(e);
        }
    }

    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Integer.toString(value));
    }

    public void writeUInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Integer.toString(value));
    }

    public void writeSInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Integer.toString(value));
    }

    public void writeFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Integer.toString(value));
    }

    public void writeSFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Integer.toString(value));
    }

    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Long.toString(value));
    }

    public void writeUInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Long.toString(value));
    }

    public void writeSInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Long.toString(value));
    }

    public void writeFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Long.toString(value));
    }

    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Long.toString(value));
    }

    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Float.toString(value));
    }

    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Double.toString(value));
    }

    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), String.valueOf(value));
    }

    public void writeEnum(int fieldNumber, int value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Integer.toString(value));
    }

    public void writeString(int fieldNumber, String value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), value);
    }

    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        this.writeByteArray(fieldNumber, value.getBytes(), repeated);
    }

    public void writeByteArray(int fieldNumber, byte[] value, boolean repeated) throws IOException {
        XMLStreamWriter writer = this.writer;
        try {
            writer.writeStartElement(this.schema.getFieldName(fieldNumber));
            writer.writeCData(StringSerializer.STRING.deser((byte[])value));
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlOutputException(e);
        }
    }

    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) throws IOException {
        if (utf8String) {
            this.writeString(fieldNumber, StringSerializer.STRING.deser((byte[])value, (int)offset, (int)length), repeated);
            return;
        }
        XMLStreamWriter writer = this.writer;
        try {
            writer.writeStartElement(this.schema.getFieldName(fieldNumber));
            writer.writeCData(StringSerializer.STRING.deser((byte[])value, (int)offset, (int)length));
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlOutputException(e);
        }
    }

    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        Schema<?> lastSchema = this.schema;
        this.schema = schema;
        XMLStreamWriter writer = this.writer;
        try {
            writer.writeStartElement(lastSchema.getFieldName(fieldNumber));
            writer.writeStartElement(schema.messageName());
            schema.writeTo((Output)this, value);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlOutputException(e);
        }
        this.schema = lastSchema;
    }
}

