/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.org.jets3t.service.utils;

import com.cloudera.org.jets3t.service.Constants;
import com.cloudera.org.jets3t.service.ServiceException;
import com.cloudera.org.jets3t.service.acl.AccessControlList;
import com.cloudera.org.jets3t.service.io.BytesProgressWatcher;
import com.cloudera.org.jets3t.service.io.GZipDeflatingInputStream;
import com.cloudera.org.jets3t.service.io.ProgressMonitoredInputStream;
import com.cloudera.org.jets3t.service.io.TempFile;
import com.cloudera.org.jets3t.service.model.S3Object;
import com.cloudera.org.jets3t.service.model.StorageObject;
import com.cloudera.org.jets3t.service.multi.DownloadPackage;
import com.cloudera.org.jets3t.service.security.EncryptionUtil;
import com.cloudera.org.jets3t.service.utils.Mimetypes;
import com.cloudera.org.jets3t.service.utils.ServiceUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectUtils {
    private static final Log log = LogFactory.getLog(ObjectUtils.class);

    public static S3Object createObjectForUpload(String objectKey, File dataFile, EncryptionUtil encryptionUtil, boolean gzipFile, BytesProgressWatcher progressWatcher) throws Exception {
        S3Object s3Object = new S3Object(objectKey);
        s3Object.setAcl(AccessControlList.REST_CANNED_PRIVATE);
        s3Object.addMetadata("jets3t-original-file-date-iso8601", ServiceUtils.formatIso8601Date(new Date(dataFile.lastModified())));
        if (dataFile.isDirectory()) {
            s3Object.setContentLength(0L);
            s3Object.setContentType("binary/octet-stream");
        } else {
            s3Object.setContentType(Mimetypes.getInstance().getMimetype(dataFile));
            File uploadFile = ObjectUtils.transformUploadFile(dataFile, s3Object, encryptionUtil, gzipFile, progressWatcher);
            s3Object.setContentLength(uploadFile.length());
            s3Object.setDataInputFile(uploadFile);
            InputStream inputStream = new BufferedInputStream(new FileInputStream(uploadFile));
            if (progressWatcher != null) {
                inputStream = new ProgressMonitoredInputStream(inputStream, progressWatcher);
            }
            s3Object.setMd5Hash(ServiceUtils.computeMD5Hash(inputStream));
            if (!uploadFile.equals(dataFile)) {
                inputStream = new BufferedInputStream(new FileInputStream(dataFile));
                if (progressWatcher != null) {
                    inputStream = new ProgressMonitoredInputStream(inputStream, progressWatcher);
                }
                s3Object.addMetadata("original-md5-hash", ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(inputStream)));
            }
        }
        return s3Object;
    }

    public static S3Object createObjectForUpload(String objectKey, File dataFile, EncryptionUtil encryptionUtil, boolean gzipFile) throws Exception {
        return ObjectUtils.createObjectForUpload(objectKey, dataFile, encryptionUtil, gzipFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File transformUploadFile(File dataFile, S3Object s3Object, EncryptionUtil encryptionUtil, boolean gzipFile, BytesProgressWatcher progressWatcher) throws Exception {
        if (!gzipFile && encryptionUtil == null) {
            return dataFile;
        }
        String actionText = "";
        TempFile tempUploadFile = new TempFile(File.createTempFile("JetS3t", ".tmp"));
        tempUploadFile.deleteOnExit();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(dataFile));
            outputStream = new BufferedOutputStream(new FileOutputStream(tempUploadFile));
            String contentEncoding = null;
            if (gzipFile) {
                inputStream = new GZipDeflatingInputStream(inputStream);
                contentEncoding = "gzip";
                s3Object.addMetadata("jets3t-compression", "gzip");
                actionText = actionText + "Compressing";
            }
            if (encryptionUtil != null) {
                inputStream = encryptionUtil.encrypt(inputStream);
                contentEncoding = null;
                s3Object.setContentType("application/octet-stream");
                s3Object.addMetadata("jets3t-crypto-alg", encryptionUtil.getAlgorithm());
                s3Object.addMetadata("jets3t-crypto-ver", "2");
                actionText = actionText + (actionText.length() == 0 ? "Encrypting" : " and encrypting");
            }
            if (contentEncoding != null) {
                s3Object.addMetadata("Content-Encoding", contentEncoding);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Transforming upload file '" + dataFile + "' to temporary file '" + tempUploadFile.getAbsolutePath() + "': " + actionText));
            }
            if (progressWatcher != null) {
                inputStream = new ProgressMonitoredInputStream(inputStream, progressWatcher);
            }
            byte[] buffer = new byte[8192];
            int c = -1;
            while ((c = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, c);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return tempUploadFile;
    }

    public static DownloadPackage createPackageForDownload(StorageObject object, File fileTarget, boolean automaticUnzip, boolean automaticDecrypt, String encryptionPassword) throws Exception {
        if (object.isDirectoryPlaceholder()) {
            return null;
        }
        boolean isZipped = false;
        EncryptionUtil encryptionUtil = null;
        if (automaticUnzip && ("gzip".equalsIgnoreCase(object.getContentEncoding()) || object.containsMetadata("jets3t-compression"))) {
            isZipped = true;
        }
        if (automaticDecrypt && object.containsMetadata("jets3t-crypto-alg")) {
            if (encryptionPassword == null) {
                throw new ServiceException("One or more objects are encrypted, and cannot be downloaded unless  the encyption password is provided");
            }
            String algorithm = (String)object.getMetadata("jets3t-crypto-alg");
            String version = (String)object.getMetadata("jets3t-crypto-ver");
            if (version == null) {
                version = "2";
            }
            encryptionUtil = new EncryptionUtil(encryptionPassword, algorithm, version);
        }
        return new DownloadPackage(object, fileTarget, isZipped, encryptionUtil);
    }

    @Deprecated
    public static com.cloudera.org.jets3t.service.multithread.DownloadPackage createPackageForDownload(S3Object object, File fileTarget, boolean automaticUnzip, boolean automaticDecrypt, String encryptionPassword) throws Exception {
        if (object.isDirectoryPlaceholder()) {
            return null;
        }
        boolean isZipped = false;
        EncryptionUtil encryptionUtil = null;
        if (automaticUnzip && ("gzip".equalsIgnoreCase(object.getContentEncoding()) || object.containsMetadata("jets3t-compression"))) {
            isZipped = true;
        }
        if (automaticDecrypt && object.containsMetadata("jets3t-crypto-alg")) {
            if (encryptionPassword == null) {
                throw new ServiceException("One or more objects are encrypted, and cannot be downloaded unless  the encyption password is provided");
            }
            String algorithm = (String)object.getMetadata("jets3t-crypto-alg");
            String version = (String)object.getMetadata("jets3t-crypto-ver");
            if (version == null) {
                version = "2";
            }
            encryptionUtil = new EncryptionUtil(encryptionPassword, algorithm, version);
        }
        return new com.cloudera.org.jets3t.service.multithread.DownloadPackage(object, fileTarget, isZipped, encryptionUtil);
    }

    public static String convertDirPlaceholderKeyNameToDirName(String objectKey) {
        String dirPlaceholderKey = objectKey;
        if (dirPlaceholderKey.endsWith("_$folder$")) {
            int suffixPos = dirPlaceholderKey.indexOf("_$");
            dirPlaceholderKey = dirPlaceholderKey.substring(0, suffixPos);
        }
        if (!dirPlaceholderKey.endsWith(Constants.FILE_PATH_DELIM)) {
            dirPlaceholderKey = dirPlaceholderKey + Constants.FILE_PATH_DELIM;
        }
        return dirPlaceholderKey;
    }
}

