/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.http;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.http.AmazonHttpClient;
import com.cloudera.com.amazonaws.http.ConnectionManagerFactory;
import com.cloudera.com.amazonaws.http.impl.client.HttpRequestNoRetryHandler;
import com.cloudera.com.amazonaws.http.impl.client.SdkHttpClient;
import com.cloudera.org.apache.http.Header;
import com.cloudera.org.apache.http.HttpHost;
import com.cloudera.org.apache.http.HttpRequest;
import com.cloudera.org.apache.http.HttpRequestInterceptor;
import com.cloudera.org.apache.http.HttpResponse;
import com.cloudera.org.apache.http.ProtocolException;
import com.cloudera.org.apache.http.auth.AuthScope;
import com.cloudera.org.apache.http.auth.ChallengeState;
import com.cloudera.org.apache.http.auth.NTCredentials;
import com.cloudera.org.apache.http.client.AuthCache;
import com.cloudera.org.apache.http.client.HttpClient;
import com.cloudera.org.apache.http.conn.ConnectTimeoutException;
import com.cloudera.org.apache.http.conn.scheme.PlainSocketFactory;
import com.cloudera.org.apache.http.conn.scheme.Scheme;
import com.cloudera.org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import com.cloudera.org.apache.http.conn.scheme.SchemeRegistry;
import com.cloudera.org.apache.http.conn.scheme.SchemeSocketFactory;
import com.cloudera.org.apache.http.conn.ssl.SSLSocketFactory;
import com.cloudera.org.apache.http.impl.auth.BasicScheme;
import com.cloudera.org.apache.http.impl.client.BasicAuthCache;
import com.cloudera.org.apache.http.impl.client.DefaultRedirectStrategy;
import com.cloudera.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.cloudera.org.apache.http.params.BasicHttpParams;
import com.cloudera.org.apache.http.params.HttpConnectionParams;
import com.cloudera.org.apache.http.params.HttpParams;
import com.cloudera.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

class HttpClientFactory {
    HttpClientFactory() {
    }

    public HttpClient createHttpClient(ClientConfiguration config) {
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(httpClientParams, config.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout(httpClientParams, config.getSocketTimeout());
        HttpConnectionParams.setStaleCheckingEnabled(httpClientParams, true);
        HttpConnectionParams.setTcpNoDelay(httpClientParams, true);
        int socketSendBufferSizeHint = config.getSocketBufferSizeHints()[0];
        int socketReceiveBufferSizeHint = config.getSocketBufferSizeHints()[1];
        if (socketSendBufferSizeHint > 0 || socketReceiveBufferSizeHint > 0) {
            HttpConnectionParams.setSocketBufferSize(httpClientParams, Math.max(socketSendBufferSizeHint, socketReceiveBufferSizeHint));
        }
        PoolingClientConnectionManager connectionManager = ConnectionManagerFactory.createPoolingClientConnManager(config, httpClientParams);
        SdkHttpClient httpClient = new SdkHttpClient(connectionManager, httpClientParams);
        httpClient.setHttpRequestRetryHandler(HttpRequestNoRetryHandler.Singleton);
        httpClient.setRedirectStrategy(new LocationHeaderNotRequiredRedirectStrategy());
        try {
            Scheme http = new Scheme("http", 80, PlainSocketFactory.getSocketFactory());
            SSLSocketFactory sf = new SSLSocketFactory(SSLContext.getDefault(), SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
            Scheme https = new Scheme("https", 443, sf);
            SchemeRegistry sr = connectionManager.getSchemeRegistry();
            sr.register(http);
            sr.register(https);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AmazonClientException("Unable to access default SSL context", e);
        }
        if (System.getProperty("com.cloudera.com.amazonaws.sdk.disableCertChecking") != null) {
            Scheme sch = new Scheme("https", 443, new TrustingSocketFactory());
            httpClient.getConnectionManager().getSchemeRegistry().register(sch);
        }
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            AmazonHttpClient.log.info((Object)("Configuring Proxy. Proxy Host: " + proxyHost + " " + "Proxy Port: " + proxyPort));
            HttpHost proxyHttpHost = new HttpHost(proxyHost, proxyPort);
            httpClient.getParams().setParameter("http.route.default-proxy", proxyHttpHost);
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            String proxyDomain = config.getProxyDomain();
            String proxyWorkstation = config.getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
            if (config.isPreemptiveBasicProxyAuth()) {
                httpClient.addRequestInterceptor(new PreemptiveProxyAuth(proxyHttpHost), 0);
            }
        }
        return httpClient;
    }

    private static class PreemptiveProxyAuth
    implements HttpRequestInterceptor {
        private final HttpHost proxyHost;

        public PreemptiveProxyAuth(HttpHost proxyHost) {
            this.proxyHost = proxyHost;
        }

        public void process(HttpRequest request, HttpContext context) {
            BasicScheme basicScheme = new BasicScheme(ChallengeState.PROXY);
            if (context.getAttribute("http.auth.auth-cache") == null) {
                BasicAuthCache authCache = new BasicAuthCache();
                authCache.put(this.proxyHost, basicScheme);
                context.setAttribute("http.auth.auth-cache", authCache);
            } else {
                AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
                authCache.put(this.proxyHost, basicScheme);
            }
        }
    }

    private static class TrustingX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] X509_CERTIFICATES = new X509Certificate[0];

        private TrustingX509TrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return X509_CERTIFICATES;
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    private static class TrustingSocketFactory
    implements SchemeSocketFactory,
    SchemeLayeredSocketFactory {
        private SSLContext sslcontext = null;

        private TrustingSocketFactory() {
        }

        private static SSLContext createSSLContext() throws IOException {
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, new TrustManager[]{new TrustingX509TrustManager()}, null);
                return context;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        private SSLContext getSSLContext() throws IOException {
            if (this.sslcontext == null) {
                this.sslcontext = TrustingSocketFactory.createSSLContext();
            }
            return this.sslcontext;
        }

        public Socket createSocket(HttpParams params) throws IOException {
            return this.getSSLContext().getSocketFactory().createSocket();
        }

        public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            int connTimeout = HttpConnectionParams.getConnectionTimeout(params);
            int soTimeout = HttpConnectionParams.getSoTimeout(params);
            SSLSocket sslsock = (SSLSocket)(sock != null ? sock : this.createSocket(params));
            if (localAddress != null) {
                sslsock.bind(localAddress);
            }
            sslsock.connect(remoteAddress, connTimeout);
            sslsock.setSoTimeout(soTimeout);
            return sslsock;
        }

        public boolean isSecure(Socket sock) throws IllegalArgumentException {
            return true;
        }

        public Socket createLayeredSocket(Socket arg0, String arg1, int arg2, HttpParams arg3) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(arg0, arg1, arg2, true);
        }
    }

    private static final class LocationHeaderNotRequiredRedirectStrategy
    extends DefaultRedirectStrategy {
        private LocationHeaderNotRequiredRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            int statusCode = response.getStatusLine().getStatusCode();
            Header locationHeader = response.getFirstHeader("location");
            if (locationHeader == null && statusCode == 301) {
                return false;
            }
            return super.isRedirected(request, response, context);
        }
    }
}

