/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.http;

import com.cloudera.com.amazonaws.AmazonWebServiceResponse;
import com.cloudera.com.amazonaws.ResponseMetadata;
import com.cloudera.com.amazonaws.http.HttpResponse;
import com.cloudera.com.amazonaws.http.HttpResponseHandler;
import com.cloudera.com.amazonaws.internal.CRC32MismatchException;
import com.cloudera.com.amazonaws.transform.JsonUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import com.cloudera.com.amazonaws.transform.VoidJsonUnmarshaller;
import com.cloudera.com.amazonaws.util.CRC32ChecksumCalculatingInputStream;
import com.cloudera.com.fasterxml.jackson.core.JsonFactory;
import com.cloudera.com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog((String)"com.cloudera.com.amazonaws.request");
    private static JsonFactory jsonFactory = new JsonFactory();
    public boolean needsConnectionLeftOpen = false;

    public JsonResponseHandler(Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidJsonUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        log.trace((Object)"Parsing service response JSON");
        String CRC32Checksum = response.getHeaders().get("x-amz-crc32");
        CRC32ChecksumCalculatingInputStream crc32ChecksumInputStream = null;
        JsonParser jsonParser = null;
        if (!this.needsConnectionLeftOpen) {
            if (CRC32Checksum != null) {
                crc32ChecksumInputStream = new CRC32ChecksumCalculatingInputStream(response.getContent());
                jsonParser = jsonFactory.createParser(crc32ChecksumInputStream);
            } else {
                jsonParser = jsonFactory.createParser(response.getContent());
            }
        }
        try {
            AmazonWebServiceResponse<T> awsResponse = new AmazonWebServiceResponse<T>();
            JsonUnmarshallerContext unmarshallerContext = new JsonUnmarshallerContext(jsonParser, response);
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            if (CRC32Checksum != null) {
                long serverSideCRC = Long.parseLong(CRC32Checksum);
                long clientSideCRC = crc32ChecksumInputStream.getCRC32Checksum();
                if (clientSideCRC != serverSideCRC) {
                    throw new CRC32MismatchException("Client calculated crc32 checksum didn't match that calculated by server side");
                }
            }
            awsResponse.setResult(result);
            Map<String, String> metadata = unmarshallerContext.getMetadata();
            metadata.put("AWS_REQUEST_ID", response.getHeaders().get("x-amzn-RequestId"));
            awsResponse.setResponseMetadata(new ResponseMetadata(metadata));
            log.trace((Object)"Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse = awsResponse;
            return amazonWebServiceResponse;
        }
        finally {
            if (!this.needsConnectionLeftOpen) {
                try {
                    jsonParser.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Error closing json parser", (Throwable)e);
                }
            }
        }
    }

    protected void registerAdditionalMetadataExpressions(JsonUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }
}

