/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.metrics.internal.cloudwatch;

import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.metrics.AwsSdkMetrics;
import com.cloudera.com.amazonaws.metrics.MetricCollector;
import com.cloudera.com.amazonaws.metrics.internal.cloudwatch.CloudWatchMetricConfig;
import com.cloudera.com.amazonaws.metrics.internal.cloudwatch.MetricCollectorSupport;
import com.cloudera.com.amazonaws.regions.Regions;

public class DefaultMetricCollectorFactory
implements MetricCollector.Factory {
    public MetricCollector getInstance() {
        AWSCredentialsProvider provider = AwsSdkMetrics.getCredentialProvider();
        Regions region = AwsSdkMetrics.getRegion();
        Integer qSize = AwsSdkMetrics.getMetricQueueSize();
        Long timeoutMilli = AwsSdkMetrics.getQueuePollTimeoutMilli();
        CloudWatchMetricConfig config = new CloudWatchMetricConfig();
        if (provider != null) {
            config.setCredentialsProvider(provider);
        }
        if (region != null) {
            String endPoint = "monitoring." + region.getName() + ".amazonaws.com";
            config.setCloudWatchEndPoint(endPoint);
        }
        if (qSize != null) {
            config.setMetricQueueSize(qSize);
        }
        if (timeoutMilli != null) {
            config.setQueuePollTimeoutMilli(timeoutMilli);
        }
        MetricCollectorSupport.startSingleton(config);
        return MetricCollectorSupport.getInstance();
    }
}

