/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.autoscaling.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnableMetricsCollectionRequestMarshaller
implements Marshaller<Request<EnableMetricsCollectionRequest>, EnableMetricsCollectionRequest> {
    @Override
    public Request<EnableMetricsCollectionRequest> marshall(EnableMetricsCollectionRequest enableMetricsCollectionRequest) {
        if (enableMetricsCollectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableMetricsCollectionRequest> request = new DefaultRequest<EnableMetricsCollectionRequest>(enableMetricsCollectionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "EnableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        if (enableMetricsCollectionRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(enableMetricsCollectionRequest.getAutoScalingGroupName()));
        }
        List<String> metricsList = enableMetricsCollectionRequest.getMetrics();
        int metricsListIndex = 1;
        for (String metricsListValue : metricsList) {
            if (metricsListValue != null) {
                request.addParameter("Metrics.member." + metricsListIndex, StringUtils.fromString(metricsListValue));
            }
            ++metricsListIndex;
        }
        if (enableMetricsCollectionRequest.getGranularity() != null) {
            request.addParameter("Granularity", StringUtils.fromString(enableMetricsCollectionRequest.getGranularity()));
        }
        return request;
    }
}

