/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.cloudfront.model.transform;

import com.cloudera.com.amazonaws.services.cloudfront.model.AllowedMethods;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllowedMethodsStaxUnmarshaller
implements Unmarshaller<AllowedMethods, StaxUnmarshallerContext> {
    private static AllowedMethodsStaxUnmarshaller instance;

    @Override
    public AllowedMethods unmarshall(StaxUnmarshallerContext context) throws Exception {
        AllowedMethods allowedMethods = new AllowedMethods();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return allowedMethods;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    allowedMethods.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Items/Method", targetDepth)) continue;
                allowedMethods.getItems().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return allowedMethods;
    }

    public static AllowedMethodsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AllowedMethodsStaxUnmarshaller();
        }
        return instance;
    }
}

