/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.cloudfront.model.transform;

import com.cloudera.com.amazonaws.services.cloudfront.model.InvalidationSummary;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidationSummaryStaxUnmarshaller
implements Unmarshaller<InvalidationSummary, StaxUnmarshallerContext> {
    private static InvalidationSummaryStaxUnmarshaller instance;

    @Override
    public InvalidationSummary unmarshall(StaxUnmarshallerContext context) throws Exception {
        InvalidationSummary invalidationSummary = new InvalidationSummary();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return invalidationSummary;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    invalidationSummary.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreateTime", targetDepth)) {
                    invalidationSummary.setCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Status", targetDepth)) continue;
                invalidationSummary.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return invalidationSummary;
    }

    public static InvalidationSummaryStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InvalidationSummaryStaxUnmarshaller();
        }
        return instance;
    }
}

