/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.cloudfront_2012_03_15.model.transform;

import com.cloudera.com.amazonaws.services.cloudfront_2012_03_15.model.TrustedSigners;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustedSignersStaxUnmarshaller
implements Unmarshaller<TrustedSigners, StaxUnmarshallerContext> {
    private static TrustedSignersStaxUnmarshaller instance;

    @Override
    public TrustedSigners unmarshall(StaxUnmarshallerContext context) throws Exception {
        TrustedSigners trustedSigners = new TrustedSigners();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return trustedSigners;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Self", targetDepth)) {
                    trustedSigners.setSelf(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AwsAccountNumber", targetDepth)) continue;
                trustedSigners.getAwsAccountNumbers().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return trustedSigners;
    }

    public static TrustedSignersStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TrustedSignersStaxUnmarshaller();
        }
        return instance;
    }
}

