/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.cloudsearch.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceDataMap
implements Serializable {
    private String sourceName;
    private String defaultValue;
    private Map<String, String> cases;

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public SourceDataMap withSourceName(String sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public SourceDataMap withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Map<String, String> getCases() {
        if (this.cases == null) {
            this.cases = new HashMap<String, String>();
        }
        return this.cases;
    }

    public void setCases(Map<String, String> cases) {
        this.cases = cases;
    }

    public SourceDataMap withCases(Map<String, String> cases) {
        this.setCases(cases);
        return this;
    }

    public SourceDataMap addCasesEntry(String key, String value) {
        if (null == this.cases) {
            this.cases = new HashMap<String, String>();
        }
        if (this.cases.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.cases.put(key, value);
        return this;
    }

    public SourceDataMap clearCasesEntries() {
        this.cases = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceName() != null) {
            sb.append("SourceName: " + this.getSourceName() + ",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: " + this.getDefaultValue() + ",");
        }
        if (this.getCases() != null) {
            sb.append("Cases: " + this.getCases());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceName() == null ? 0 : this.getSourceName().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        hashCode = 31 * hashCode + (this.getCases() == null ? 0 : this.getCases().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDataMap)) {
            return false;
        }
        SourceDataMap other = (SourceDataMap)obj;
        if (other.getSourceName() == null ^ this.getSourceName() == null) {
            return false;
        }
        if (other.getSourceName() != null && !other.getSourceName().equals(this.getSourceName())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        if (other.getDefaultValue() != null && !other.getDefaultValue().equals(this.getDefaultValue())) {
            return false;
        }
        if (other.getCases() == null ^ this.getCases() == null) {
            return false;
        }
        return other.getCases() == null || other.getCases().equals(this.getCases());
    }
}

