/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.datapipeline;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.cloudera.com.amazonaws.handlers.AsyncHandler;
import com.cloudera.com.amazonaws.services.datapipeline.DataPipelineAsync;
import com.cloudera.com.amazonaws.services.datapipeline.DataPipelineClient;
import com.cloudera.com.amazonaws.services.datapipeline.model.ActivatePipelineRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.ActivatePipelineResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.CreatePipelineRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.CreatePipelineResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.DeletePipelineRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.DescribeObjectsRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.DescribeObjectsResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.DescribePipelinesRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.DescribePipelinesResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.EvaluateExpressionResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.GetPipelineDefinitionResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.ListPipelinesRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.ListPipelinesResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.PollForTaskRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.PollForTaskResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.PutPipelineDefinitionResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.QueryObjectsRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.QueryObjectsResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.ReportTaskProgressResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.SetStatusRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.SetTaskStatusRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.SetTaskStatusResult;
import com.cloudera.com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import com.cloudera.com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataPipelineAsyncClient
extends DataPipelineClient
implements DataPipelineAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public DataPipelineAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public DataPipelineAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public DataPipelineAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public DataPipelineAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public DataPipelineAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public DataPipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public DataPipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public DataPipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public DataPipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<ActivatePipelineResult> activatePipelineAsync(final ActivatePipelineRequest activatePipelineRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ActivatePipelineResult>(){

            @Override
            public ActivatePipelineResult call() throws Exception {
                return DataPipelineAsyncClient.this.activatePipeline(activatePipelineRequest);
            }
        });
    }

    @Override
    public Future<ActivatePipelineResult> activatePipelineAsync(final ActivatePipelineRequest activatePipelineRequest, final AsyncHandler<ActivatePipelineRequest, ActivatePipelineResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ActivatePipelineResult>(){

            @Override
            public ActivatePipelineResult call() throws Exception {
                ActivatePipelineResult result;
                try {
                    result = DataPipelineAsyncClient.this.activatePipeline(activatePipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(activatePipelineRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(final ListPipelinesRequest listPipelinesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                return DataPipelineAsyncClient.this.listPipelines(listPipelinesRequest);
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(final ListPipelinesRequest listPipelinesRequest, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result;
                try {
                    result = DataPipelineAsyncClient.this.listPipelines(listPipelinesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listPipelinesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReportTaskProgressResult> reportTaskProgressAsync(final ReportTaskProgressRequest reportTaskProgressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReportTaskProgressResult>(){

            @Override
            public ReportTaskProgressResult call() throws Exception {
                return DataPipelineAsyncClient.this.reportTaskProgress(reportTaskProgressRequest);
            }
        });
    }

    @Override
    public Future<ReportTaskProgressResult> reportTaskProgressAsync(final ReportTaskProgressRequest reportTaskProgressRequest, final AsyncHandler<ReportTaskProgressRequest, ReportTaskProgressResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReportTaskProgressResult>(){

            @Override
            public ReportTaskProgressResult call() throws Exception {
                ReportTaskProgressResult result;
                try {
                    result = DataPipelineAsyncClient.this.reportTaskProgress(reportTaskProgressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(reportTaskProgressRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ValidatePipelineDefinitionResult> validatePipelineDefinitionAsync(final ValidatePipelineDefinitionRequest validatePipelineDefinitionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ValidatePipelineDefinitionResult>(){

            @Override
            public ValidatePipelineDefinitionResult call() throws Exception {
                return DataPipelineAsyncClient.this.validatePipelineDefinition(validatePipelineDefinitionRequest);
            }
        });
    }

    @Override
    public Future<ValidatePipelineDefinitionResult> validatePipelineDefinitionAsync(final ValidatePipelineDefinitionRequest validatePipelineDefinitionRequest, final AsyncHandler<ValidatePipelineDefinitionRequest, ValidatePipelineDefinitionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ValidatePipelineDefinitionResult>(){

            @Override
            public ValidatePipelineDefinitionResult call() throws Exception {
                ValidatePipelineDefinitionResult result;
                try {
                    result = DataPipelineAsyncClient.this.validatePipelineDefinition(validatePipelineDefinitionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(validatePipelineDefinitionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<PollForTaskResult> pollForTaskAsync(final PollForTaskRequest pollForTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PollForTaskResult>(){

            @Override
            public PollForTaskResult call() throws Exception {
                return DataPipelineAsyncClient.this.pollForTask(pollForTaskRequest);
            }
        });
    }

    @Override
    public Future<PollForTaskResult> pollForTaskAsync(final PollForTaskRequest pollForTaskRequest, final AsyncHandler<PollForTaskRequest, PollForTaskResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PollForTaskResult>(){

            @Override
            public PollForTaskResult call() throws Exception {
                PollForTaskResult result;
                try {
                    result = DataPipelineAsyncClient.this.pollForTask(pollForTaskRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(pollForTaskRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<QueryObjectsResult> queryObjectsAsync(final QueryObjectsRequest queryObjectsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<QueryObjectsResult>(){

            @Override
            public QueryObjectsResult call() throws Exception {
                return DataPipelineAsyncClient.this.queryObjects(queryObjectsRequest);
            }
        });
    }

    @Override
    public Future<QueryObjectsResult> queryObjectsAsync(final QueryObjectsRequest queryObjectsRequest, final AsyncHandler<QueryObjectsRequest, QueryObjectsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<QueryObjectsResult>(){

            @Override
            public QueryObjectsResult call() throws Exception {
                QueryObjectsResult result;
                try {
                    result = DataPipelineAsyncClient.this.queryObjects(queryObjectsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(queryObjectsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> setStatusAsync(final SetStatusRequest setStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DataPipelineAsyncClient.this.setStatus(setStatusRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setStatusAsync(final SetStatusRequest setStatusRequest, final AsyncHandler<SetStatusRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    DataPipelineAsyncClient.this.setStatus(setStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setStatusRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deletePipelineAsync(final DeletePipelineRequest deletePipelineRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DataPipelineAsyncClient.this.deletePipeline(deletePipelineRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deletePipelineAsync(final DeletePipelineRequest deletePipelineRequest, final AsyncHandler<DeletePipelineRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    DataPipelineAsyncClient.this.deletePipeline(deletePipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deletePipelineRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetPipelineDefinitionResult> getPipelineDefinitionAsync(final GetPipelineDefinitionRequest getPipelineDefinitionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetPipelineDefinitionResult>(){

            @Override
            public GetPipelineDefinitionResult call() throws Exception {
                return DataPipelineAsyncClient.this.getPipelineDefinition(getPipelineDefinitionRequest);
            }
        });
    }

    @Override
    public Future<GetPipelineDefinitionResult> getPipelineDefinitionAsync(final GetPipelineDefinitionRequest getPipelineDefinitionRequest, final AsyncHandler<GetPipelineDefinitionRequest, GetPipelineDefinitionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetPipelineDefinitionResult>(){

            @Override
            public GetPipelineDefinitionResult call() throws Exception {
                GetPipelineDefinitionResult result;
                try {
                    result = DataPipelineAsyncClient.this.getPipelineDefinition(getPipelineDefinitionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getPipelineDefinitionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<SetTaskStatusResult> setTaskStatusAsync(final SetTaskStatusRequest setTaskStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SetTaskStatusResult>(){

            @Override
            public SetTaskStatusResult call() throws Exception {
                return DataPipelineAsyncClient.this.setTaskStatus(setTaskStatusRequest);
            }
        });
    }

    @Override
    public Future<SetTaskStatusResult> setTaskStatusAsync(final SetTaskStatusRequest setTaskStatusRequest, final AsyncHandler<SetTaskStatusRequest, SetTaskStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SetTaskStatusResult>(){

            @Override
            public SetTaskStatusResult call() throws Exception {
                SetTaskStatusResult result;
                try {
                    result = DataPipelineAsyncClient.this.setTaskStatus(setTaskStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setTaskStatusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<EvaluateExpressionResult> evaluateExpressionAsync(final EvaluateExpressionRequest evaluateExpressionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EvaluateExpressionResult>(){

            @Override
            public EvaluateExpressionResult call() throws Exception {
                return DataPipelineAsyncClient.this.evaluateExpression(evaluateExpressionRequest);
            }
        });
    }

    @Override
    public Future<EvaluateExpressionResult> evaluateExpressionAsync(final EvaluateExpressionRequest evaluateExpressionRequest, final AsyncHandler<EvaluateExpressionRequest, EvaluateExpressionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EvaluateExpressionResult>(){

            @Override
            public EvaluateExpressionResult call() throws Exception {
                EvaluateExpressionResult result;
                try {
                    result = DataPipelineAsyncClient.this.evaluateExpression(evaluateExpressionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(evaluateExpressionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribePipelinesResult> describePipelinesAsync(final DescribePipelinesRequest describePipelinesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePipelinesResult>(){

            @Override
            public DescribePipelinesResult call() throws Exception {
                return DataPipelineAsyncClient.this.describePipelines(describePipelinesRequest);
            }
        });
    }

    @Override
    public Future<DescribePipelinesResult> describePipelinesAsync(final DescribePipelinesRequest describePipelinesRequest, final AsyncHandler<DescribePipelinesRequest, DescribePipelinesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePipelinesResult>(){

            @Override
            public DescribePipelinesResult call() throws Exception {
                DescribePipelinesResult result;
                try {
                    result = DataPipelineAsyncClient.this.describePipelines(describePipelinesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describePipelinesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(final CreatePipelineRequest createPipelineRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                return DataPipelineAsyncClient.this.createPipeline(createPipelineRequest);
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(final CreatePipelineRequest createPipelineRequest, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result;
                try {
                    result = DataPipelineAsyncClient.this.createPipeline(createPipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createPipelineRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeObjectsResult> describeObjectsAsync(final DescribeObjectsRequest describeObjectsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeObjectsResult>(){

            @Override
            public DescribeObjectsResult call() throws Exception {
                return DataPipelineAsyncClient.this.describeObjects(describeObjectsRequest);
            }
        });
    }

    @Override
    public Future<DescribeObjectsResult> describeObjectsAsync(final DescribeObjectsRequest describeObjectsRequest, final AsyncHandler<DescribeObjectsRequest, DescribeObjectsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeObjectsResult>(){

            @Override
            public DescribeObjectsResult call() throws Exception {
                DescribeObjectsResult result;
                try {
                    result = DataPipelineAsyncClient.this.describeObjects(describeObjectsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeObjectsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReportTaskRunnerHeartbeatResult> reportTaskRunnerHeartbeatAsync(final ReportTaskRunnerHeartbeatRequest reportTaskRunnerHeartbeatRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReportTaskRunnerHeartbeatResult>(){

            @Override
            public ReportTaskRunnerHeartbeatResult call() throws Exception {
                return DataPipelineAsyncClient.this.reportTaskRunnerHeartbeat(reportTaskRunnerHeartbeatRequest);
            }
        });
    }

    @Override
    public Future<ReportTaskRunnerHeartbeatResult> reportTaskRunnerHeartbeatAsync(final ReportTaskRunnerHeartbeatRequest reportTaskRunnerHeartbeatRequest, final AsyncHandler<ReportTaskRunnerHeartbeatRequest, ReportTaskRunnerHeartbeatResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReportTaskRunnerHeartbeatResult>(){

            @Override
            public ReportTaskRunnerHeartbeatResult call() throws Exception {
                ReportTaskRunnerHeartbeatResult result;
                try {
                    result = DataPipelineAsyncClient.this.reportTaskRunnerHeartbeat(reportTaskRunnerHeartbeatRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(reportTaskRunnerHeartbeatRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<PutPipelineDefinitionResult> putPipelineDefinitionAsync(final PutPipelineDefinitionRequest putPipelineDefinitionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutPipelineDefinitionResult>(){

            @Override
            public PutPipelineDefinitionResult call() throws Exception {
                return DataPipelineAsyncClient.this.putPipelineDefinition(putPipelineDefinitionRequest);
            }
        });
    }

    @Override
    public Future<PutPipelineDefinitionResult> putPipelineDefinitionAsync(final PutPipelineDefinitionRequest putPipelineDefinitionRequest, final AsyncHandler<PutPipelineDefinitionRequest, PutPipelineDefinitionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutPipelineDefinitionResult>(){

            @Override
            public PutPipelineDefinitionResult call() throws Exception {
                PutPipelineDefinitionResult result;
                try {
                    result = DataPipelineAsyncClient.this.putPipelineDefinition(putPipelineDefinitionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putPipelineDefinitionRequest, result);
                return result;
            }
        });
    }
}

