/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.datapipeline.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.http.HttpMethodName;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.datapipeline.model.Field;
import com.cloudera.com.amazonaws.services.datapipeline.model.PipelineObject;
import com.cloudera.com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringInputStream;
import com.cloudera.com.amazonaws.util.StringUtils;
import com.cloudera.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatePipelineDefinitionRequestMarshaller
implements Marshaller<Request<ValidatePipelineDefinitionRequest>, ValidatePipelineDefinitionRequest> {
    @Override
    public Request<ValidatePipelineDefinitionRequest> marshall(ValidatePipelineDefinitionRequest validatePipelineDefinitionRequest) {
        if (validatePipelineDefinitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ValidatePipelineDefinitionRequest> request = new DefaultRequest<ValidatePipelineDefinitionRequest>(validatePipelineDefinitionRequest, "DataPipeline");
        String target = "DataPipeline.ValidatePipelineDefinition";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag pipelineObjectsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (validatePipelineDefinitionRequest.getPipelineId() != null) {
                jsonWriter.key("pipelineId").value(validatePipelineDefinitionRequest.getPipelineId());
            }
            if (!((pipelineObjectsList = (ListWithAutoConstructFlag)validatePipelineDefinitionRequest.getPipelineObjects()) == null || pipelineObjectsList.isAutoConstruct() && pipelineObjectsList.isEmpty())) {
                jsonWriter.key("pipelineObjects");
                jsonWriter.array();
                for (PipelineObject pipelineObjectsListValue : pipelineObjectsList) {
                    ListWithAutoConstructFlag fieldsList;
                    if (pipelineObjectsListValue == null) continue;
                    jsonWriter.object();
                    if (pipelineObjectsListValue.getId() != null) {
                        jsonWriter.key("id").value(pipelineObjectsListValue.getId());
                    }
                    if (pipelineObjectsListValue.getName() != null) {
                        jsonWriter.key("name").value(pipelineObjectsListValue.getName());
                    }
                    if (!((fieldsList = (ListWithAutoConstructFlag)pipelineObjectsListValue.getFields()) == null || fieldsList.isAutoConstruct() && fieldsList.isEmpty())) {
                        jsonWriter.key("fields");
                        jsonWriter.array();
                        for (Field fieldsListValue : fieldsList) {
                            if (fieldsListValue == null) continue;
                            jsonWriter.object();
                            if (fieldsListValue.getKey() != null) {
                                jsonWriter.key("key").value(fieldsListValue.getKey());
                            }
                            if (fieldsListValue.getStringValue() != null) {
                                jsonWriter.key("stringValue").value(fieldsListValue.getStringValue());
                            }
                            if (fieldsListValue.getRefValue() != null) {
                                jsonWriter.key("refValue").value(fieldsListValue.getRefValue());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

