/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.ec2.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.ec2.model.ReservedInstancesConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyReservedInstancesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String clientToken;
    private ListWithAutoConstructFlag<String> reservedInstancesIds;
    private ListWithAutoConstructFlag<ReservedInstancesConfiguration> targetConfigurations;

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public ModifyReservedInstancesRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public List<String> getReservedInstancesIds() {
        if (this.reservedInstancesIds == null) {
            this.reservedInstancesIds = new ListWithAutoConstructFlag();
            this.reservedInstancesIds.setAutoConstruct(true);
        }
        return this.reservedInstancesIds;
    }

    public void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
        if (reservedInstancesIds == null) {
            this.reservedInstancesIds = null;
            return;
        }
        ListWithAutoConstructFlag reservedInstancesIdsCopy = new ListWithAutoConstructFlag(reservedInstancesIds.size());
        reservedInstancesIdsCopy.addAll(reservedInstancesIds);
        this.reservedInstancesIds = reservedInstancesIdsCopy;
    }

    public ModifyReservedInstancesRequest withReservedInstancesIds(String ... reservedInstancesIds) {
        if (this.getReservedInstancesIds() == null) {
            this.setReservedInstancesIds(new ArrayList<String>(reservedInstancesIds.length));
        }
        for (String value : reservedInstancesIds) {
            this.getReservedInstancesIds().add(value);
        }
        return this;
    }

    public ModifyReservedInstancesRequest withReservedInstancesIds(Collection<String> reservedInstancesIds) {
        if (reservedInstancesIds == null) {
            this.reservedInstancesIds = null;
        } else {
            ListWithAutoConstructFlag reservedInstancesIdsCopy = new ListWithAutoConstructFlag(reservedInstancesIds.size());
            reservedInstancesIdsCopy.addAll(reservedInstancesIds);
            this.reservedInstancesIds = reservedInstancesIdsCopy;
        }
        return this;
    }

    public List<ReservedInstancesConfiguration> getTargetConfigurations() {
        if (this.targetConfigurations == null) {
            this.targetConfigurations = new ListWithAutoConstructFlag();
            this.targetConfigurations.setAutoConstruct(true);
        }
        return this.targetConfigurations;
    }

    public void setTargetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations) {
        if (targetConfigurations == null) {
            this.targetConfigurations = null;
            return;
        }
        ListWithAutoConstructFlag targetConfigurationsCopy = new ListWithAutoConstructFlag(targetConfigurations.size());
        targetConfigurationsCopy.addAll(targetConfigurations);
        this.targetConfigurations = targetConfigurationsCopy;
    }

    public ModifyReservedInstancesRequest withTargetConfigurations(ReservedInstancesConfiguration ... targetConfigurations) {
        if (this.getTargetConfigurations() == null) {
            this.setTargetConfigurations(new ArrayList<ReservedInstancesConfiguration>(targetConfigurations.length));
        }
        for (ReservedInstancesConfiguration value : targetConfigurations) {
            this.getTargetConfigurations().add(value);
        }
        return this;
    }

    public ModifyReservedInstancesRequest withTargetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations) {
        if (targetConfigurations == null) {
            this.targetConfigurations = null;
        } else {
            ListWithAutoConstructFlag targetConfigurationsCopy = new ListWithAutoConstructFlag(targetConfigurations.size());
            targetConfigurationsCopy.addAll(targetConfigurations);
            this.targetConfigurations = targetConfigurationsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken() + ",");
        }
        if (this.getReservedInstancesIds() != null) {
            sb.append("ReservedInstancesIds: " + this.getReservedInstancesIds() + ",");
        }
        if (this.getTargetConfigurations() != null) {
            sb.append("TargetConfigurations: " + this.getTargetConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getReservedInstancesIds() == null ? 0 : this.getReservedInstancesIds().hashCode());
        hashCode = 31 * hashCode + (this.getTargetConfigurations() == null ? 0 : this.getTargetConfigurations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReservedInstancesRequest)) {
            return false;
        }
        ModifyReservedInstancesRequest other = (ModifyReservedInstancesRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getReservedInstancesIds() == null ^ this.getReservedInstancesIds() == null) {
            return false;
        }
        if (other.getReservedInstancesIds() != null && !other.getReservedInstancesIds().equals(this.getReservedInstancesIds())) {
            return false;
        }
        if (other.getTargetConfigurations() == null ^ this.getTargetConfigurations() == null) {
            return false;
        }
        return other.getTargetConfigurations() == null || other.getTargetConfigurations().equals(this.getTargetConfigurations());
    }
}

