/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.ec2.model;

import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.ec2.model.IpPermission;
import com.cloudera.com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityGroup
implements Serializable {
    private String ownerId;
    private String groupName;
    private String groupId;
    private String description;
    private ListWithAutoConstructFlag<IpPermission> ipPermissions;
    private ListWithAutoConstructFlag<IpPermission> ipPermissionsEgress;
    private String vpcId;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public SecurityGroup withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public SecurityGroup withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public SecurityGroup withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SecurityGroup withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<IpPermission> getIpPermissions() {
        if (this.ipPermissions == null) {
            this.ipPermissions = new ListWithAutoConstructFlag();
            this.ipPermissions.setAutoConstruct(true);
        }
        return this.ipPermissions;
    }

    public void setIpPermissions(Collection<IpPermission> ipPermissions) {
        if (ipPermissions == null) {
            this.ipPermissions = null;
            return;
        }
        ListWithAutoConstructFlag ipPermissionsCopy = new ListWithAutoConstructFlag(ipPermissions.size());
        ipPermissionsCopy.addAll(ipPermissions);
        this.ipPermissions = ipPermissionsCopy;
    }

    public SecurityGroup withIpPermissions(IpPermission ... ipPermissions) {
        if (this.getIpPermissions() == null) {
            this.setIpPermissions(new ArrayList<IpPermission>(ipPermissions.length));
        }
        for (IpPermission value : ipPermissions) {
            this.getIpPermissions().add(value);
        }
        return this;
    }

    public SecurityGroup withIpPermissions(Collection<IpPermission> ipPermissions) {
        if (ipPermissions == null) {
            this.ipPermissions = null;
        } else {
            ListWithAutoConstructFlag ipPermissionsCopy = new ListWithAutoConstructFlag(ipPermissions.size());
            ipPermissionsCopy.addAll(ipPermissions);
            this.ipPermissions = ipPermissionsCopy;
        }
        return this;
    }

    public List<IpPermission> getIpPermissionsEgress() {
        if (this.ipPermissionsEgress == null) {
            this.ipPermissionsEgress = new ListWithAutoConstructFlag();
            this.ipPermissionsEgress.setAutoConstruct(true);
        }
        return this.ipPermissionsEgress;
    }

    public void setIpPermissionsEgress(Collection<IpPermission> ipPermissionsEgress) {
        if (ipPermissionsEgress == null) {
            this.ipPermissionsEgress = null;
            return;
        }
        ListWithAutoConstructFlag ipPermissionsEgressCopy = new ListWithAutoConstructFlag(ipPermissionsEgress.size());
        ipPermissionsEgressCopy.addAll(ipPermissionsEgress);
        this.ipPermissionsEgress = ipPermissionsEgressCopy;
    }

    public SecurityGroup withIpPermissionsEgress(IpPermission ... ipPermissionsEgress) {
        if (this.getIpPermissionsEgress() == null) {
            this.setIpPermissionsEgress(new ArrayList<IpPermission>(ipPermissionsEgress.length));
        }
        for (IpPermission value : ipPermissionsEgress) {
            this.getIpPermissionsEgress().add(value);
        }
        return this;
    }

    public SecurityGroup withIpPermissionsEgress(Collection<IpPermission> ipPermissionsEgress) {
        if (ipPermissionsEgress == null) {
            this.ipPermissionsEgress = null;
        } else {
            ListWithAutoConstructFlag ipPermissionsEgressCopy = new ListWithAutoConstructFlag(ipPermissionsEgress.size());
            ipPermissionsEgressCopy.addAll(ipPermissionsEgress);
            this.ipPermissionsEgress = ipPermissionsEgressCopy;
        }
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public SecurityGroup withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public SecurityGroup withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public SecurityGroup withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: " + this.getOwnerId() + ",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: " + this.getGroupName() + ",");
        }
        if (this.getGroupId() != null) {
            sb.append("GroupId: " + this.getGroupId() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getIpPermissions() != null) {
            sb.append("IpPermissions: " + this.getIpPermissions() + ",");
        }
        if (this.getIpPermissionsEgress() != null) {
            sb.append("IpPermissionsEgress: " + this.getIpPermissionsEgress() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getIpPermissions() == null ? 0 : this.getIpPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getIpPermissionsEgress() == null ? 0 : this.getIpPermissionsEgress().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroup)) {
            return false;
        }
        SecurityGroup other = (SecurityGroup)obj;
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getIpPermissions() == null ^ this.getIpPermissions() == null) {
            return false;
        }
        if (other.getIpPermissions() != null && !other.getIpPermissions().equals(this.getIpPermissions())) {
            return false;
        }
        if (other.getIpPermissionsEgress() == null ^ this.getIpPermissionsEgress() == null) {
            return false;
        }
        if (other.getIpPermissionsEgress() != null && !other.getIpPermissionsEgress().equals(this.getIpPermissionsEgress())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }
}

