/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.ec2.model;

import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.ec2.model.VolumeStatusAction;
import com.cloudera.com.amazonaws.services.ec2.model.VolumeStatusEvent;
import com.cloudera.com.amazonaws.services.ec2.model.VolumeStatusInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolumeStatusItem
implements Serializable {
    private String volumeId;
    private String availabilityZone;
    private VolumeStatusInfo volumeStatus;
    private ListWithAutoConstructFlag<VolumeStatusEvent> events;
    private ListWithAutoConstructFlag<VolumeStatusAction> actions;

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public VolumeStatusItem withVolumeId(String volumeId) {
        this.volumeId = volumeId;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public VolumeStatusItem withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public VolumeStatusInfo getVolumeStatus() {
        return this.volumeStatus;
    }

    public void setVolumeStatus(VolumeStatusInfo volumeStatus) {
        this.volumeStatus = volumeStatus;
    }

    public VolumeStatusItem withVolumeStatus(VolumeStatusInfo volumeStatus) {
        this.volumeStatus = volumeStatus;
        return this;
    }

    public List<VolumeStatusEvent> getEvents() {
        if (this.events == null) {
            this.events = new ListWithAutoConstructFlag();
            this.events.setAutoConstruct(true);
        }
        return this.events;
    }

    public void setEvents(Collection<VolumeStatusEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
        eventsCopy.addAll(events);
        this.events = eventsCopy;
    }

    public VolumeStatusItem withEvents(VolumeStatusEvent ... events) {
        if (this.getEvents() == null) {
            this.setEvents(new ArrayList<VolumeStatusEvent>(events.length));
        }
        for (VolumeStatusEvent value : events) {
            this.getEvents().add(value);
        }
        return this;
    }

    public VolumeStatusItem withEvents(Collection<VolumeStatusEvent> events) {
        if (events == null) {
            this.events = null;
        } else {
            ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
            eventsCopy.addAll(events);
            this.events = eventsCopy;
        }
        return this;
    }

    public List<VolumeStatusAction> getActions() {
        if (this.actions == null) {
            this.actions = new ListWithAutoConstructFlag();
            this.actions.setAutoConstruct(true);
        }
        return this.actions;
    }

    public void setActions(Collection<VolumeStatusAction> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        ListWithAutoConstructFlag actionsCopy = new ListWithAutoConstructFlag(actions.size());
        actionsCopy.addAll(actions);
        this.actions = actionsCopy;
    }

    public VolumeStatusItem withActions(VolumeStatusAction ... actions) {
        if (this.getActions() == null) {
            this.setActions(new ArrayList<VolumeStatusAction>(actions.length));
        }
        for (VolumeStatusAction value : actions) {
            this.getActions().add(value);
        }
        return this;
    }

    public VolumeStatusItem withActions(Collection<VolumeStatusAction> actions) {
        if (actions == null) {
            this.actions = null;
        } else {
            ListWithAutoConstructFlag actionsCopy = new ListWithAutoConstructFlag(actions.size());
            actionsCopy.addAll(actions);
            this.actions = actionsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVolumeId() != null) {
            sb.append("VolumeId: " + this.getVolumeId() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getVolumeStatus() != null) {
            sb.append("VolumeStatus: " + this.getVolumeStatus() + ",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents() + ",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: " + this.getActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVolumeId() == null ? 0 : this.getVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeStatus() == null ? 0 : this.getVolumeStatus().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusItem)) {
            return false;
        }
        VolumeStatusItem other = (VolumeStatusItem)obj;
        if (other.getVolumeId() == null ^ this.getVolumeId() == null) {
            return false;
        }
        if (other.getVolumeId() != null && !other.getVolumeId().equals(this.getVolumeId())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getVolumeStatus() == null ^ this.getVolumeStatus() == null) {
            return false;
        }
        if (other.getVolumeStatus() != null && !other.getVolumeStatus().equals(this.getVolumeStatus())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        return other.getActions() == null || other.getActions().equals(this.getActions());
    }
}

