/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticbeanstalk.model.transform;

import com.cloudera.com.amazonaws.services.elasticbeanstalk.model.ApplicationVersionDescription;
import com.cloudera.com.amazonaws.services.elasticbeanstalk.model.transform.S3LocationStaxUnmarshaller;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationVersionDescriptionStaxUnmarshaller
implements Unmarshaller<ApplicationVersionDescription, StaxUnmarshallerContext> {
    private static ApplicationVersionDescriptionStaxUnmarshaller instance;

    @Override
    public ApplicationVersionDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        ApplicationVersionDescription applicationVersionDescription = new ApplicationVersionDescription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return applicationVersionDescription;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ApplicationName", targetDepth)) {
                    applicationVersionDescription.setApplicationName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    applicationVersionDescription.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VersionLabel", targetDepth)) {
                    applicationVersionDescription.setVersionLabel(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceBundle", targetDepth)) {
                    applicationVersionDescription.setSourceBundle(S3LocationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DateCreated", targetDepth)) {
                    applicationVersionDescription.setDateCreated(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DateUpdated", targetDepth)) continue;
                applicationVersionDescription.setDateUpdated(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return applicationVersionDescription;
    }

    public static ApplicationVersionDescriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ApplicationVersionDescriptionStaxUnmarshaller();
        }
        return instance;
    }
}

