/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticbeanstalk.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.cloudera.com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import com.cloudera.com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateConfigurationTemplateRequestMarshaller
implements Marshaller<Request<CreateConfigurationTemplateRequest>, CreateConfigurationTemplateRequest> {
    @Override
    public Request<CreateConfigurationTemplateRequest> marshall(CreateConfigurationTemplateRequest createConfigurationTemplateRequest) {
        SourceConfiguration sourceConfigurationSourceConfiguration;
        if (createConfigurationTemplateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateConfigurationTemplateRequest> request = new DefaultRequest<CreateConfigurationTemplateRequest>(createConfigurationTemplateRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateConfigurationTemplate");
        request.addParameter("Version", "2010-12-01");
        if (createConfigurationTemplateRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString(createConfigurationTemplateRequest.getApplicationName()));
        }
        if (createConfigurationTemplateRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString(createConfigurationTemplateRequest.getTemplateName()));
        }
        if (createConfigurationTemplateRequest.getSolutionStackName() != null) {
            request.addParameter("SolutionStackName", StringUtils.fromString(createConfigurationTemplateRequest.getSolutionStackName()));
        }
        if ((sourceConfigurationSourceConfiguration = createConfigurationTemplateRequest.getSourceConfiguration()) != null) {
            if (sourceConfigurationSourceConfiguration.getApplicationName() != null) {
                request.addParameter("SourceConfiguration.ApplicationName", StringUtils.fromString(sourceConfigurationSourceConfiguration.getApplicationName()));
            }
            if (sourceConfigurationSourceConfiguration.getTemplateName() != null) {
                request.addParameter("SourceConfiguration.TemplateName", StringUtils.fromString(sourceConfigurationSourceConfiguration.getTemplateName()));
            }
        }
        if (createConfigurationTemplateRequest.getEnvironmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString(createConfigurationTemplateRequest.getEnvironmentId()));
        }
        if (createConfigurationTemplateRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createConfigurationTemplateRequest.getDescription()));
        }
        List<ConfigurationOptionSetting> optionSettingsList = createConfigurationTemplateRequest.getOptionSettings();
        int optionSettingsListIndex = 1;
        for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
            ConfigurationOptionSetting configurationOptionSettingMember = optionSettingsListValue;
            if (configurationOptionSettingMember != null) {
                if (configurationOptionSettingMember.getNamespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString(configurationOptionSettingMember.getNamespace()));
                }
                if (configurationOptionSettingMember.getOptionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString(configurationOptionSettingMember.getOptionName()));
                }
                if (configurationOptionSettingMember.getValue() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString(configurationOptionSettingMember.getValue()));
                }
            }
            ++optionSettingsListIndex;
        }
        return request;
    }
}

