/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticbeanstalk.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteApplicationRequestMarshaller
implements Marshaller<Request<DeleteApplicationRequest>, DeleteApplicationRequest> {
    @Override
    public Request<DeleteApplicationRequest> marshall(DeleteApplicationRequest deleteApplicationRequest) {
        if (deleteApplicationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteApplicationRequest> request = new DefaultRequest<DeleteApplicationRequest>(deleteApplicationRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DeleteApplication");
        request.addParameter("Version", "2010-12-01");
        if (deleteApplicationRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString(deleteApplicationRequest.getApplicationName()));
        }
        if (deleteApplicationRequest.isTerminateEnvByForce() != null) {
            request.addParameter("TerminateEnvByForce", StringUtils.fromBoolean(deleteApplicationRequest.isTerminateEnvByForce()));
        }
        return request;
    }
}

