/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticbeanstalk.model.transform;

import com.cloudera.com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3LocationStaxUnmarshaller
implements Unmarshaller<S3Location, StaxUnmarshallerContext> {
    private static S3LocationStaxUnmarshaller instance;

    @Override
    public S3Location unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3Location s3Location = new S3Location();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3Location;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("S3Bucket", targetDepth)) {
                    s3Location.setS3Bucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("S3Key", targetDepth)) continue;
                s3Location.setS3Key(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3Location;
    }

    public static S3LocationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3LocationStaxUnmarshaller();
        }
        return instance;
    }
}

