/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticloadbalancing.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteLoadBalancerListenersRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String loadBalancerName;
    private ListWithAutoConstructFlag<Integer> loadBalancerPorts;

    public DeleteLoadBalancerListenersRequest() {
    }

    public DeleteLoadBalancerListenersRequest(String loadBalancerName, List<Integer> loadBalancerPorts) {
        this.setLoadBalancerName(loadBalancerName);
        this.setLoadBalancerPorts(loadBalancerPorts);
    }

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public DeleteLoadBalancerListenersRequest withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public List<Integer> getLoadBalancerPorts() {
        if (this.loadBalancerPorts == null) {
            this.loadBalancerPorts = new ListWithAutoConstructFlag();
            this.loadBalancerPorts.setAutoConstruct(true);
        }
        return this.loadBalancerPorts;
    }

    public void setLoadBalancerPorts(Collection<Integer> loadBalancerPorts) {
        if (loadBalancerPorts == null) {
            this.loadBalancerPorts = null;
            return;
        }
        ListWithAutoConstructFlag loadBalancerPortsCopy = new ListWithAutoConstructFlag(loadBalancerPorts.size());
        loadBalancerPortsCopy.addAll(loadBalancerPorts);
        this.loadBalancerPorts = loadBalancerPortsCopy;
    }

    public DeleteLoadBalancerListenersRequest withLoadBalancerPorts(Integer ... loadBalancerPorts) {
        if (this.getLoadBalancerPorts() == null) {
            this.setLoadBalancerPorts(new ArrayList<Integer>(loadBalancerPorts.length));
        }
        for (Integer value : loadBalancerPorts) {
            this.getLoadBalancerPorts().add(value);
        }
        return this;
    }

    public DeleteLoadBalancerListenersRequest withLoadBalancerPorts(Collection<Integer> loadBalancerPorts) {
        if (loadBalancerPorts == null) {
            this.loadBalancerPorts = null;
        } else {
            ListWithAutoConstructFlag loadBalancerPortsCopy = new ListWithAutoConstructFlag(loadBalancerPorts.size());
            loadBalancerPortsCopy.addAll(loadBalancerPorts);
            this.loadBalancerPorts = loadBalancerPortsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerName() != null) {
            sb.append("LoadBalancerName: " + this.getLoadBalancerName() + ",");
        }
        if (this.getLoadBalancerPorts() != null) {
            sb.append("LoadBalancerPorts: " + this.getLoadBalancerPorts());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerName() == null ? 0 : this.getLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerPorts() == null ? 0 : this.getLoadBalancerPorts().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLoadBalancerListenersRequest)) {
            return false;
        }
        DeleteLoadBalancerListenersRequest other = (DeleteLoadBalancerListenersRequest)obj;
        if (other.getLoadBalancerName() == null ^ this.getLoadBalancerName() == null) {
            return false;
        }
        if (other.getLoadBalancerName() != null && !other.getLoadBalancerName().equals(this.getLoadBalancerName())) {
            return false;
        }
        if (other.getLoadBalancerPorts() == null ^ this.getLoadBalancerPorts() == null) {
            return false;
        }
        return other.getLoadBalancerPorts() == null || other.getLoadBalancerPorts().equals(this.getLoadBalancerPorts());
    }
}

