/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticloadbalancing.model.transform;

import com.cloudera.com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HealthCheckStaxUnmarshaller
implements Unmarshaller<HealthCheck, StaxUnmarshallerContext> {
    private static HealthCheckStaxUnmarshaller instance;

    @Override
    public HealthCheck unmarshall(StaxUnmarshallerContext context) throws Exception {
        HealthCheck healthCheck = new HealthCheck();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return healthCheck;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Target", targetDepth)) {
                    healthCheck.setTarget(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Interval", targetDepth)) {
                    healthCheck.setInterval(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Timeout", targetDepth)) {
                    healthCheck.setTimeout(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UnhealthyThreshold", targetDepth)) {
                    healthCheck.setUnhealthyThreshold(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("HealthyThreshold", targetDepth)) continue;
                healthCheck.setHealthyThreshold(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return healthCheck;
    }

    public static HealthCheckStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new HealthCheckStaxUnmarshaller();
        }
        return instance;
    }
}

