/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticmapreduce.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetTerminationProtectionRequest
extends AmazonWebServiceRequest
implements Serializable {
    private ListWithAutoConstructFlag<String> jobFlowIds;
    private Boolean terminationProtected;

    public List<String> getJobFlowIds() {
        if (this.jobFlowIds == null) {
            this.jobFlowIds = new ListWithAutoConstructFlag();
            this.jobFlowIds.setAutoConstruct(true);
        }
        return this.jobFlowIds;
    }

    public void setJobFlowIds(Collection<String> jobFlowIds) {
        if (jobFlowIds == null) {
            this.jobFlowIds = null;
            return;
        }
        ListWithAutoConstructFlag jobFlowIdsCopy = new ListWithAutoConstructFlag(jobFlowIds.size());
        jobFlowIdsCopy.addAll(jobFlowIds);
        this.jobFlowIds = jobFlowIdsCopy;
    }

    public SetTerminationProtectionRequest withJobFlowIds(String ... jobFlowIds) {
        if (this.getJobFlowIds() == null) {
            this.setJobFlowIds(new ArrayList<String>(jobFlowIds.length));
        }
        for (String value : jobFlowIds) {
            this.getJobFlowIds().add(value);
        }
        return this;
    }

    public SetTerminationProtectionRequest withJobFlowIds(Collection<String> jobFlowIds) {
        if (jobFlowIds == null) {
            this.jobFlowIds = null;
        } else {
            ListWithAutoConstructFlag jobFlowIdsCopy = new ListWithAutoConstructFlag(jobFlowIds.size());
            jobFlowIdsCopy.addAll(jobFlowIds);
            this.jobFlowIds = jobFlowIdsCopy;
        }
        return this;
    }

    public Boolean isTerminationProtected() {
        return this.terminationProtected;
    }

    public void setTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
    }

    public SetTerminationProtectionRequest withTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
        return this;
    }

    public Boolean getTerminationProtected() {
        return this.terminationProtected;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobFlowIds() != null) {
            sb.append("JobFlowIds: " + this.getJobFlowIds() + ",");
        }
        if (this.isTerminationProtected() != null) {
            sb.append("TerminationProtected: " + this.isTerminationProtected());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobFlowIds() == null ? 0 : this.getJobFlowIds().hashCode());
        hashCode = 31 * hashCode + (this.isTerminationProtected() == null ? 0 : this.isTerminationProtected().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTerminationProtectionRequest)) {
            return false;
        }
        SetTerminationProtectionRequest other = (SetTerminationProtectionRequest)obj;
        if (other.getJobFlowIds() == null ^ this.getJobFlowIds() == null) {
            return false;
        }
        if (other.getJobFlowIds() != null && !other.getJobFlowIds().equals(this.getJobFlowIds())) {
            return false;
        }
        if (other.isTerminationProtected() == null ^ this.isTerminationProtected() == null) {
            return false;
        }
        return other.isTerminationProtected() == null || other.isTerminationProtected().equals(this.isTerminationProtected());
    }
}

