/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elastictranscoder.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.http.HttpMethodName;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.AudioCodecOptions;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.AudioParameters;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.CreatePresetRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.PresetWatermark;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.Thumbnails;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.VideoParameters;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringInputStream;
import com.cloudera.com.amazonaws.util.StringUtils;
import com.cloudera.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePresetRequestMarshaller
implements Marshaller<Request<CreatePresetRequest>, CreatePresetRequest> {
    @Override
    public Request<CreatePresetRequest> marshall(CreatePresetRequest createPresetRequest) {
        if (createPresetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePresetRequest> request = new DefaultRequest<CreatePresetRequest>(createPresetRequest, "AmazonElasticTranscoder");
        String target = "EtsCustomerService.CreatePreset";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "2012-09-25/presets";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            Thumbnails thumbnails;
            AudioParameters audio;
            VideoParameters video;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createPresetRequest.getName() != null) {
                jsonWriter.key("Name").value(createPresetRequest.getName());
            }
            if (createPresetRequest.getDescription() != null) {
                jsonWriter.key("Description").value(createPresetRequest.getDescription());
            }
            if (createPresetRequest.getContainer() != null) {
                jsonWriter.key("Container").value(createPresetRequest.getContainer());
            }
            if ((video = createPresetRequest.getVideo()) != null) {
                ListWithAutoConstructFlag watermarksList;
                jsonWriter.key("Video");
                jsonWriter.object();
                if (video.getCodec() != null) {
                    jsonWriter.key("Codec").value(video.getCodec());
                }
                if (video.getCodecOptions() != null) {
                    jsonWriter.key("CodecOptions");
                    jsonWriter.object();
                    for (Map.Entry<String, String> codecOptionsListValue : video.getCodecOptions().entrySet()) {
                        if (codecOptionsListValue.getValue() == null) continue;
                        jsonWriter.key(codecOptionsListValue.getKey());
                        jsonWriter.value(codecOptionsListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                if (video.getKeyframesMaxDist() != null) {
                    jsonWriter.key("KeyframesMaxDist").value(video.getKeyframesMaxDist());
                }
                if (video.getFixedGOP() != null) {
                    jsonWriter.key("FixedGOP").value(video.getFixedGOP());
                }
                if (video.getBitRate() != null) {
                    jsonWriter.key("BitRate").value(video.getBitRate());
                }
                if (video.getFrameRate() != null) {
                    jsonWriter.key("FrameRate").value(video.getFrameRate());
                }
                if (video.getMaxFrameRate() != null) {
                    jsonWriter.key("MaxFrameRate").value(video.getMaxFrameRate());
                }
                if (video.getResolution() != null) {
                    jsonWriter.key("Resolution").value(video.getResolution());
                }
                if (video.getAspectRatio() != null) {
                    jsonWriter.key("AspectRatio").value(video.getAspectRatio());
                }
                if (video.getMaxWidth() != null) {
                    jsonWriter.key("MaxWidth").value(video.getMaxWidth());
                }
                if (video.getMaxHeight() != null) {
                    jsonWriter.key("MaxHeight").value(video.getMaxHeight());
                }
                if (video.getDisplayAspectRatio() != null) {
                    jsonWriter.key("DisplayAspectRatio").value(video.getDisplayAspectRatio());
                }
                if (video.getSizingPolicy() != null) {
                    jsonWriter.key("SizingPolicy").value(video.getSizingPolicy());
                }
                if (video.getPaddingPolicy() != null) {
                    jsonWriter.key("PaddingPolicy").value(video.getPaddingPolicy());
                }
                if (!((watermarksList = (ListWithAutoConstructFlag)video.getWatermarks()) == null || watermarksList.isAutoConstruct() && watermarksList.isEmpty())) {
                    jsonWriter.key("Watermarks");
                    jsonWriter.array();
                    for (PresetWatermark watermarksListValue : watermarksList) {
                        if (watermarksListValue == null) continue;
                        jsonWriter.object();
                        if (watermarksListValue.getId() != null) {
                            jsonWriter.key("Id").value(watermarksListValue.getId());
                        }
                        if (watermarksListValue.getMaxWidth() != null) {
                            jsonWriter.key("MaxWidth").value(watermarksListValue.getMaxWidth());
                        }
                        if (watermarksListValue.getMaxHeight() != null) {
                            jsonWriter.key("MaxHeight").value(watermarksListValue.getMaxHeight());
                        }
                        if (watermarksListValue.getSizingPolicy() != null) {
                            jsonWriter.key("SizingPolicy").value(watermarksListValue.getSizingPolicy());
                        }
                        if (watermarksListValue.getHorizontalAlign() != null) {
                            jsonWriter.key("HorizontalAlign").value(watermarksListValue.getHorizontalAlign());
                        }
                        if (watermarksListValue.getHorizontalOffset() != null) {
                            jsonWriter.key("HorizontalOffset").value(watermarksListValue.getHorizontalOffset());
                        }
                        if (watermarksListValue.getVerticalAlign() != null) {
                            jsonWriter.key("VerticalAlign").value(watermarksListValue.getVerticalAlign());
                        }
                        if (watermarksListValue.getVerticalOffset() != null) {
                            jsonWriter.key("VerticalOffset").value(watermarksListValue.getVerticalOffset());
                        }
                        if (watermarksListValue.getOpacity() != null) {
                            jsonWriter.key("Opacity").value(watermarksListValue.getOpacity());
                        }
                        if (watermarksListValue.getTarget() != null) {
                            jsonWriter.key("Target").value(watermarksListValue.getTarget());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if ((audio = createPresetRequest.getAudio()) != null) {
                AudioCodecOptions codecOptions;
                jsonWriter.key("Audio");
                jsonWriter.object();
                if (audio.getCodec() != null) {
                    jsonWriter.key("Codec").value(audio.getCodec());
                }
                if (audio.getSampleRate() != null) {
                    jsonWriter.key("SampleRate").value(audio.getSampleRate());
                }
                if (audio.getBitRate() != null) {
                    jsonWriter.key("BitRate").value(audio.getBitRate());
                }
                if (audio.getChannels() != null) {
                    jsonWriter.key("Channels").value(audio.getChannels());
                }
                if ((codecOptions = audio.getCodecOptions()) != null) {
                    jsonWriter.key("CodecOptions");
                    jsonWriter.object();
                    if (codecOptions.getProfile() != null) {
                        jsonWriter.key("Profile").value(codecOptions.getProfile());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if ((thumbnails = createPresetRequest.getThumbnails()) != null) {
                jsonWriter.key("Thumbnails");
                jsonWriter.object();
                if (thumbnails.getFormat() != null) {
                    jsonWriter.key("Format").value(thumbnails.getFormat());
                }
                if (thumbnails.getInterval() != null) {
                    jsonWriter.key("Interval").value(thumbnails.getInterval());
                }
                if (thumbnails.getResolution() != null) {
                    jsonWriter.key("Resolution").value(thumbnails.getResolution());
                }
                if (thumbnails.getAspectRatio() != null) {
                    jsonWriter.key("AspectRatio").value(thumbnails.getAspectRatio());
                }
                if (thumbnails.getMaxWidth() != null) {
                    jsonWriter.key("MaxWidth").value(thumbnails.getMaxWidth());
                }
                if (thumbnails.getMaxHeight() != null) {
                    jsonWriter.key("MaxHeight").value(thumbnails.getMaxHeight());
                }
                if (thumbnails.getSizingPolicy() != null) {
                    jsonWriter.key("SizingPolicy").value(thumbnails.getSizingPolicy());
                }
                if (thumbnails.getPaddingPolicy() != null) {
                    jsonWriter.key("PaddingPolicy").value(thumbnails.getPaddingPolicy());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

