/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.glacier.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.http.HttpMethodName;
import com.cloudera.com.amazonaws.services.glacier.model.ListJobsRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListJobsRequestMarshaller
implements Marshaller<Request<ListJobsRequest>, ListJobsRequest> {
    @Override
    public Request<ListJobsRequest> marshall(ListJobsRequest listJobsRequest) {
        if (listJobsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListJobsRequest> request = new DefaultRequest<ListJobsRequest>(listJobsRequest, "AmazonGlacier");
        String target = "Glacier.ListJobs";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs?marker={marker};limit={limit};completed={completed};statuscode={statuscode}";
        uriResourcePath = uriResourcePath.replace("{accountId}", listJobsRequest.getAccountId() == null ? "" : StringUtils.fromString(listJobsRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{vaultName}", listJobsRequest.getVaultName() == null ? "" : StringUtils.fromString(listJobsRequest.getVaultName()));
        uriResourcePath = uriResourcePath.replace("{limit}", listJobsRequest.getLimit() == null ? "" : StringUtils.fromString(listJobsRequest.getLimit()));
        uriResourcePath = uriResourcePath.replace("{marker}", listJobsRequest.getMarker() == null ? "" : StringUtils.fromString(listJobsRequest.getMarker()));
        uriResourcePath = uriResourcePath.replace("{statuscode}", listJobsRequest.getStatuscode() == null ? "" : StringUtils.fromString(listJobsRequest.getStatuscode()));
        uriResourcePath = uriResourcePath.replace("{completed}", listJobsRequest.getCompleted() == null ? "" : StringUtils.fromString(listJobsRequest.getCompleted()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

