/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.glacier.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.http.HttpMethodName;
import com.cloudera.com.amazonaws.services.glacier.model.ListVaultsRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListVaultsRequestMarshaller
implements Marshaller<Request<ListVaultsRequest>, ListVaultsRequest> {
    @Override
    public Request<ListVaultsRequest> marshall(ListVaultsRequest listVaultsRequest) {
        if (listVaultsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListVaultsRequest> request = new DefaultRequest<ListVaultsRequest>(listVaultsRequest, "AmazonGlacier");
        String target = "Glacier.ListVaults";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults?marker={marker};limit={limit}";
        uriResourcePath = uriResourcePath.replace("{accountId}", listVaultsRequest.getAccountId() == null ? "" : StringUtils.fromString(listVaultsRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{marker}", listVaultsRequest.getMarker() == null ? "" : StringUtils.fromString(listVaultsRequest.getMarker()));
        uriResourcePath = uriResourcePath.replace("{limit}", listVaultsRequest.getLimit() == null ? "" : StringUtils.fromString(listVaultsRequest.getLimit()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

