/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.kinesis;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.cloudera.com.amazonaws.handlers.AsyncHandler;
import com.cloudera.com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.cloudera.com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.cloudera.com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.cloudera.com.amazonaws.services.kinesis.model.DeleteStreamRequest;
import com.cloudera.com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.cloudera.com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.cloudera.com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.cloudera.com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.cloudera.com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.cloudera.com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.cloudera.com.amazonaws.services.kinesis.model.ListStreamsRequest;
import com.cloudera.com.amazonaws.services.kinesis.model.ListStreamsResult;
import com.cloudera.com.amazonaws.services.kinesis.model.MergeShardsRequest;
import com.cloudera.com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.cloudera.com.amazonaws.services.kinesis.model.PutRecordResult;
import com.cloudera.com.amazonaws.services.kinesis.model.SplitShardRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonKinesisAsyncClient
extends AmazonKinesisClient
implements AmazonKinesisAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonKinesisAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonKinesisAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonKinesisAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonKinesisAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonKinesisAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonKinesisAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonKinesisAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonKinesisAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonKinesisAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(final DescribeStreamRequest describeStreamRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStreamResult>(){

            @Override
            public DescribeStreamResult call() throws Exception {
                return AmazonKinesisAsyncClient.this.describeStream(describeStreamRequest);
            }
        });
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(final DescribeStreamRequest describeStreamRequest, final AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStreamResult>(){

            @Override
            public DescribeStreamResult call() throws Exception {
                DescribeStreamResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.describeStream(describeStreamRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeStreamRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(final GetShardIteratorRequest getShardIteratorRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetShardIteratorResult>(){

            @Override
            public GetShardIteratorResult call() throws Exception {
                return AmazonKinesisAsyncClient.this.getShardIterator(getShardIteratorRequest);
            }
        });
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(final GetShardIteratorRequest getShardIteratorRequest, final AsyncHandler<GetShardIteratorRequest, GetShardIteratorResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetShardIteratorResult>(){

            @Override
            public GetShardIteratorResult call() throws Exception {
                GetShardIteratorResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.getShardIterator(getShardIteratorRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getShardIteratorRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(final PutRecordRequest putRecordRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutRecordResult>(){

            @Override
            public PutRecordResult call() throws Exception {
                return AmazonKinesisAsyncClient.this.putRecord(putRecordRequest);
            }
        });
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(final PutRecordRequest putRecordRequest, final AsyncHandler<PutRecordRequest, PutRecordResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutRecordResult>(){

            @Override
            public PutRecordResult call() throws Exception {
                PutRecordResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.putRecord(putRecordRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putRecordRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetRecordsResult> getRecordsAsync(final GetRecordsRequest getRecordsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetRecordsResult>(){

            @Override
            public GetRecordsResult call() throws Exception {
                return AmazonKinesisAsyncClient.this.getRecords(getRecordsRequest);
            }
        });
    }

    @Override
    public Future<GetRecordsResult> getRecordsAsync(final GetRecordsRequest getRecordsRequest, final AsyncHandler<GetRecordsRequest, GetRecordsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetRecordsResult>(){

            @Override
            public GetRecordsResult call() throws Exception {
                GetRecordsResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.getRecords(getRecordsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getRecordsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> splitShardAsync(final SplitShardRequest splitShardRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonKinesisAsyncClient.this.splitShard(splitShardRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> splitShardAsync(final SplitShardRequest splitShardRequest, final AsyncHandler<SplitShardRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonKinesisAsyncClient.this.splitShard(splitShardRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(splitShardRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createStreamAsync(final CreateStreamRequest createStreamRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonKinesisAsyncClient.this.createStream(createStreamRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createStreamAsync(final CreateStreamRequest createStreamRequest, final AsyncHandler<CreateStreamRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonKinesisAsyncClient.this.createStream(createStreamRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createStreamRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteStreamAsync(final DeleteStreamRequest deleteStreamRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonKinesisAsyncClient.this.deleteStream(deleteStreamRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteStreamAsync(final DeleteStreamRequest deleteStreamRequest, final AsyncHandler<DeleteStreamRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonKinesisAsyncClient.this.deleteStream(deleteStreamRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteStreamRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(final ListStreamsRequest listStreamsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListStreamsResult>(){

            @Override
            public ListStreamsResult call() throws Exception {
                return AmazonKinesisAsyncClient.this.listStreams(listStreamsRequest);
            }
        });
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(final ListStreamsRequest listStreamsRequest, final AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListStreamsResult>(){

            @Override
            public ListStreamsResult call() throws Exception {
                ListStreamsResult result;
                try {
                    result = AmazonKinesisAsyncClient.this.listStreams(listStreamsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listStreamsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> mergeShardsAsync(final MergeShardsRequest mergeShardsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonKinesisAsyncClient.this.mergeShards(mergeShardsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> mergeShardsAsync(final MergeShardsRequest mergeShardsRequest, final AsyncHandler<MergeShardsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonKinesisAsyncClient.this.mergeShards(mergeShardsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(mergeShardsRequest, null);
                return null;
            }
        });
    }
}

