/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.rds.model.transform;

import com.cloudera.com.amazonaws.services.rds.model.DBEngineVersion;
import com.cloudera.com.amazonaws.services.rds.model.transform.CharacterSetStaxUnmarshaller;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBEngineVersionStaxUnmarshaller
implements Unmarshaller<DBEngineVersion, StaxUnmarshallerContext> {
    private static DBEngineVersionStaxUnmarshaller instance;

    @Override
    public DBEngineVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        DBEngineVersion dBEngineVersion = new DBEngineVersion();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dBEngineVersion;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Engine", targetDepth)) {
                    dBEngineVersion.setEngine(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    dBEngineVersion.setEngineVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBParameterGroupFamily", targetDepth)) {
                    dBEngineVersion.setDBParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBEngineDescription", targetDepth)) {
                    dBEngineVersion.setDBEngineDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBEngineVersionDescription", targetDepth)) {
                    dBEngineVersion.setDBEngineVersionDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DefaultCharacterSet", targetDepth)) {
                    dBEngineVersion.setDefaultCharacterSet(CharacterSetStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SupportedCharacterSets/CharacterSet", targetDepth)) continue;
                dBEngineVersion.getSupportedCharacterSets().add(CharacterSetStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dBEngineVersion;
    }

    public static DBEngineVersionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DBEngineVersionStaxUnmarshaller();
        }
        return instance;
    }
}

